/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.packets;

import java.util.function.Supplier;
import net.kaneka.planttech2.tileentity.machine.TileEntityCompressor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ButtonPressMessage {
    private int x;
    private int y;
    private int z;
    private int buttonId;

    public ButtonPressMessage(int x, int y, int z, int buttonId) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.buttonId = buttonId;
    }

    public static void encode(ButtonPressMessage pkt, PacketBuffer buf) {
        buf.writeInt(pkt.x);
        buf.writeInt(pkt.y);
        buf.writeInt(pkt.z);
        buf.writeInt(pkt.buttonId);
    }

    public static ButtonPressMessage decode(PacketBuffer buf) {
        return new ButtonPressMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static class ButtonPressMessageHandler {
        public static void handle(ButtonPressMessage pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EntityPlayerMP serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
                BlockPos pos = new BlockPos(pkt.x, pkt.y, pkt.z);
                int buttonId = pkt.buttonId;
                serverPlayer.func_71121_q().func_152344_a(() -> {
                    TileEntity te;
                    if (serverPlayer.field_70170_p.func_175667_e(pos) && (te = serverPlayer.field_70170_p.func_175625_s(pos)) != null && te instanceof TileEntityCompressor) {
                        ((TileEntityCompressor)te).setSelectedId(buttonId);
                    }
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

