/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.recipes.recipeclasses;

import com.google.gson.JsonObject;
import net.kaneka.planttech2.recipes.ModRecipeSerializers;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.utilities.TagUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;

public class CompressorRecipe
implements IRecipe {
    private final ResourceLocation id;
    private final ItemStack input;
    private final ItemStack output;

    public CompressorRecipe(ResourceLocation id, ItemStack input, ItemStack output) {
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.input.func_77973_b() == inv.func_70301_a(0).func_77973_b();
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public int getAmountInput() {
        return this.input.func_190916_E();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.COMPRESSING;
    }

    public RecipeType<? extends IRecipe> getType() {
        return ModRecipeTypes.COMPRESSING;
    }

    public static class Serializer
    implements IRecipeSerializer<CompressorRecipe> {
        private static ResourceLocation NAME = new ResourceLocation("planttech2", "compressing");

        public CompressorRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputobject = json.getAsJsonObject("input");
            Item inputitem = null;
            if (inputobject.has("item")) {
                inputitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("item").getAsString()));
            } else if (inputobject.has("block")) {
                inputitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("block").getAsString()));
            } else if (inputobject.has("tag")) {
                inputitem = TagUtils.getAnyTagItem(new ResourceLocation(inputobject.get("tag").getAsString()));
            }
            ItemStack inputstack = null;
            if (inputitem != null) {
                inputstack = new ItemStack((IItemProvider)inputitem, JsonUtils.func_151208_a((JsonObject)inputobject, (String)"amount", (int)1));
            }
            JsonObject resultobject = json.getAsJsonObject("result");
            Item resultitem = null;
            if (resultobject.has("item")) {
                resultitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("item").getAsString()));
            } else if (resultobject.has("block")) {
                resultitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("block").getAsString()));
            } else if (resultobject.has("tag")) {
                resultitem = TagUtils.getAnyTagItem(new ResourceLocation(resultobject.get("tag").getAsString()));
            }
            ItemStack resultstack = null;
            if (resultitem != null) {
                resultstack = new ItemStack((IItemProvider)resultitem, JsonUtils.func_151208_a((JsonObject)resultobject, (String)"amount", (int)1));
            }
            if (inputstack != null && resultstack != null) {
                return new CompressorRecipe(recipeId, inputstack, resultstack);
            }
            throw new IllegalStateException("Item did not exist:" + recipeId.toString());
        }

        public CompressorRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ItemStack input = buffer.func_150791_c();
            ItemStack result = buffer.func_150791_c();
            return new CompressorRecipe(recipeId, input, result);
        }

        public void write(PacketBuffer buffer, CompressorRecipe recipe) {
            buffer.func_150788_a(recipe.input);
            buffer.func_150788_a(recipe.output);
        }

        public ResourceLocation getName() {
            return NAME;
        }
    }
}

