/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.kaneka.planttech2.container.ContainerCompressor;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.CompressorRecipe;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.TileEntityEnergyInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityCompressor
extends TileEntityEnergyInventory {
    private int ticksPassed = 0;
    private int selectedId = -1;
    private HashMap<Integer, Pair<ItemStack, Integer>> recipeList = null;
    private ItemStack previousInput = null;

    public TileEntityCompressor() {
        super(ModTileEntities.COMPRESSOR_TE, 1000, 23);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() <= this.energyPerTick()) {
            // empty if block
        }
        ItemStack stack1 = this.itemhandler.getStackInSlot(0);
        ItemStack stack2 = this.itemhandler.getStackInSlot(1);
        if (!stack1.func_190926_b() && this.selectedId >= 0) {
            if (this.recipeList != null) {
                if (!this.recipeList.isEmpty() && this.recipeList.size() > this.selectedId) {
                    Pair<ItemStack, Integer> recipe = this.recipeList.get(this.selectedId);
                    int neededInput = (Integer)recipe.getValue();
                    ItemStack stackOutput = ((ItemStack)recipe.getKey()).func_77946_l();
                    if (neededInput <= stack1.func_190916_E()) {
                        if (this.ticksPassed < this.ticksPerItem()) {
                            ++this.ticksPassed;
                        } else if (stack2.func_190926_b()) {
                            this.itemhandler.setStackInSlot(1, stackOutput);
                            stack1.func_190918_g(neededInput);
                            this.ticksPassed = 0;
                        } else if (stack2.func_77973_b() == stackOutput.func_77973_b() && stack2.func_77976_d() >= stack2.func_190916_E() + stackOutput.func_190916_E()) {
                            stack2.func_190917_f(stackOutput.func_190916_E());
                            stack1.func_190918_g(neededInput);
                            this.ticksPassed = 0;
                        }
                    }
                } else {
                    this.selectedId = -3;
                }
            } else if (this.selectedId >= 0) {
                this.initRecipeList();
            }
        }
    }

    public void setSelectedId(int selectedId) {
        this.selectedId = selectedId;
    }

    public void setRecipe() {
        if (this.previousInput == null) {
            this.selectedId = -2;
            this.initRecipeList();
        } else if (this.previousInput.func_77973_b() != this.itemhandler.getStackInSlot(0).func_77973_b()) {
            this.selectedId = -2;
            this.initRecipeList();
        }
    }

    public void initRecipeList() {
        for (int i = 0; i < 20; ++i) {
            this.itemhandler.setStackInSlot(i + 3, ItemStack.field_190927_a);
        }
        HashMap<Integer, Pair> temprecipeList = new HashMap<Integer, Pair>();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        this.recipeList = new HashMap();
        for (CompressorRecipe recipe : this.field_145850_b.func_199532_z().getRecipes(ModRecipeTypes.COMPRESSING)) {
            if (!recipe.func_77569_a(this, this.field_145850_b)) continue;
            temprecipeList.put(Item.func_150891_b((Item)recipe.func_77571_b().func_77973_b()), Pair.of((Object)recipe.func_77571_b(), (Object)recipe.getAmountInput()));
            keys.add(Item.func_150891_b((Item)recipe.func_77571_b().func_77973_b()));
        }
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            this.recipeList.put(i, (Pair<ItemStack, Integer>)temprecipeList.get(keys.get(i)));
            this.itemhandler.setStackInSlot(i + 3, (ItemStack)((Pair)temprecipeList.get(keys.get(i))).getLeft());
        }
        this.ticksPassed = 0;
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(3, 2) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(3, 2) * 35;
    }

    @Override
    public String getNameString() {
        return "compressor";
    }

    @Override
    public List<ItemStack> getInventoryContent() {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        for (int i = 0; i < 3; ++i) {
            stack.add(this.itemhandler.getStackInSlot(i).func_77946_l());
        }
        return stack;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tickspassed", this.ticksPassed);
        compound.func_74768_a("selectedId", this.selectedId);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.ticksPassed = compound.func_74762_e("tickspassed");
        this.selectedId = compound.func_74762_e("selectedId");
        super.func_145839_a(compound);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return super.func_174887_a_(id);
            }
            case 2: {
                return this.ticksPassed;
            }
            case 3: {
                return this.selectedId;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: 
            case 1: {
                super.func_174885_b(id, value);
                break;
            }
            case 2: {
                this.ticksPassed = value;
                break;
            }
            case 3: {
                this.selectedId = value;
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 4;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCompressor(playerInventory, this);
    }
}

