/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.Random;
import net.kaneka.planttech2.container.ContainerDNACombiner;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.TileEntityEnergyInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;

public class TileEntityDNACombiner
extends TileEntityEnergyInventory {
    private int ticksPassed = 0;

    public TileEntityDNACombiner() {
        super(ModTileEntities.DNACOMBINER_TE, 1000, 5);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() <= this.energyPerTick()) {
            // empty if block
        }
        ItemStack stack1 = this.itemhandler.getStackInSlot(0);
        ItemStack stack2 = this.itemhandler.getStackInSlot(1);
        ItemStack stack3 = this.itemhandler.getStackInSlot(2);
        ItemStack stack4 = this.itemhandler.getStackInSlot(3);
        if (!stack1.func_190926_b() && !stack2.func_190926_b() && !stack3.func_190926_b() && stack4.func_190926_b() && stack1.func_77973_b() == ModItems.DNA_CONTAINER && stack2.func_77973_b() == ModItems.DNA_CONTAINER && stack1.func_77942_o() && stack2.func_77942_o() && stack3.func_77973_b() == ModItems.DNA_CONTAINER_EMPTY) {
            if (this.ticksPassed < this.ticksPerItem()) {
                ++this.ticksPassed;
            } else {
                this.ticksPassed = 0;
                NBTTagCompound nbt = this.getCombinedNBT(stack1.func_77978_p(), stack2.func_77978_p());
                ItemStack stack = new ItemStack((IItemProvider)ModItems.DNA_CONTAINER);
                stack.func_77982_d(nbt);
                this.itemhandler.setStackInSlot(3, stack);
                stack3.func_190918_g(1);
            }
        }
    }

    private NBTTagCompound getCombinedNBT(NBTTagCompound nbt1, NBTTagCompound nbt2) {
        NBTTagCompound newNBT = new NBTTagCompound();
        Random rand = new Random();
        for (String key : HashMapCropTraits.getTraitsKeyList()) {
            if (key.equals("type")) {
                if (nbt1.func_74764_b(key) && !nbt2.func_74764_b(key)) {
                    newNBT.func_74778_a(key, nbt1.func_74779_i(key));
                    continue;
                }
                if (!nbt1.func_74764_b(key) && nbt2.func_74764_b(key)) {
                    newNBT.func_74778_a(key, nbt2.func_74779_i(key));
                    continue;
                }
                if (!nbt1.func_74764_b(key) || !nbt2.func_74764_b(key)) continue;
                if (rand.nextBoolean()) {
                    newNBT.func_74778_a(key, nbt1.func_74779_i(key));
                    continue;
                }
                newNBT.func_74778_a(key, nbt2.func_74779_i(key));
                continue;
            }
            if (nbt1.func_74764_b(key) && !nbt2.func_74764_b(key)) {
                newNBT.func_74768_a(key, nbt1.func_74762_e(key));
                continue;
            }
            if (!nbt1.func_74764_b(key) && nbt2.func_74764_b(key)) {
                newNBT.func_74768_a(key, nbt2.func_74762_e(key));
                continue;
            }
            if (!nbt1.func_74764_b(key) || !nbt2.func_74764_b(key)) continue;
            newNBT.func_74768_a(key, Math.min(nbt1.func_74762_e(key), nbt2.func_74762_e(key)));
        }
        return newNBT;
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(4, 2) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(4, 2) * 35;
    }

    @Override
    public String getNameString() {
        return "dnacombiner";
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tickspassed", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.ticksPassed = compound.func_74762_e("tickspassed");
        super.func_145839_a(compound);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return super.func_174887_a_(id);
            }
            case 2: {
                return this.ticksPassed;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: 
            case 1: {
                super.func_174885_b(id, value);
                break;
            }
            case 2: {
                this.ticksPassed = value;
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 3;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDNACombiner(playerInventory, this);
    }
}

