/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kaneka.planttech2.container.ContainerDNARemover;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.TileEntityEnergyInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;

public class TileEntityDNARemover
extends TileEntityEnergyInventory {
    private int ticksPassed = 0;

    public TileEntityDNARemover() {
        super(ModTileEntities.DNAREMOVER_TE, 1000, 3);
    }

    @Override
    public void doUpdate() {
        List<String> traitsList;
        if (this.energystorage.getEnergyStored() <= this.energyPerTick()) {
            // empty if block
        }
        ItemStack stack1 = this.itemhandler.getStackInSlot(0);
        ItemStack stack2 = this.itemhandler.getStackInSlot(1);
        if (!stack1.func_190926_b() && stack2.func_190926_b() && stack1.func_77973_b() == ModItems.DNA_CONTAINER && (traitsList = this.getAvailableTraits(stack1)).size() > 1) {
            if (this.ticksPassed < this.ticksPerItem()) {
                ++this.ticksPassed;
            } else {
                Collections.shuffle(traitsList);
                NBTTagCompound nbt = stack1.func_77978_p().func_74737_b();
                nbt.func_82580_o(traitsList.get(0));
                ItemStack stack = new ItemStack((IItemProvider)ModItems.DNA_CONTAINER);
                stack.func_77982_d(nbt);
                this.itemhandler.setStackInSlot(1, stack);
                stack1.func_190918_g(1);
                this.ticksPassed = 0;
            }
        }
    }

    private List<String> getAvailableTraits(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            for (String key : HashMapCropTraits.getTraitsKeyList()) {
                if (!nbt.func_74764_b(key)) continue;
                list.add(key);
            }
        }
        return list;
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(2, 2) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(2, 2) * 35;
    }

    @Override
    public String getNameString() {
        return "dnayremover";
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tickspassed", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.ticksPassed = compound.func_74762_e("tickspassed");
        super.func_145839_a(compound);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return super.func_174887_a_(id);
            }
            case 2: {
                return this.ticksPassed;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: 
            case 1: {
                super.func_174885_b(id, value);
                break;
            }
            case 2: {
                this.ticksPassed = value;
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 3;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDNARemover(playerInventory, this);
    }
}

