/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.container.ContainerInfuser;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.InfuserRecipe;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.TileEntityEnergyInventoryFluid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TileEntityInfuser
extends TileEntityEnergyInventoryFluid {
    private int fluidInfused = 0;
    private int fluidTotal = 0;
    private Item output = null;

    public TileEntityInfuser() {
        super(ModTileEntities.INFUSER_TE, 1000, 5, 5000);
    }

    @Override
    public void doUpdate() {
        InfuserRecipe recipe;
        if (this.energystorage.getEnergyStored() <= this.energyPerTick()) {
            // empty if block
        }
        ItemStack stack1 = this.itemhandler.getStackInSlot(0);
        ItemStack stack2 = this.itemhandler.getStackInSlot(1);
        if (!stack1.func_190926_b() && (recipe = this.getOutputRecipe()) != null) {
            if (recipe.getOutput() == this.output || this.output == null) {
                if (this.output == null) {
                    this.output = recipe.getOutput();
                    this.fluidTotal = recipe.getBiomass();
                }
                int fluidpertick = this.fluidPerTick();
                if (this.fluidtank.getBiomass() >= fluidpertick) {
                    if (this.fluidInfused + fluidpertick < this.fluidTotal) {
                        this.fluidInfused += fluidpertick;
                        this.fluidtank.extract(fluidpertick);
                    } else if (stack2.func_190926_b()) {
                        this.itemhandler.setStackInSlot(1, recipe.func_77571_b());
                        stack1.func_190918_g(1);
                        this.fluidInfused = 0;
                        this.fluidtank.extract(this.fluidTotal - this.fluidInfused);
                    } else if (stack2.func_77973_b() == recipe.getOutput() && stack2.func_190916_E() < stack2.func_77976_d()) {
                        stack2.func_190917_f(1);
                        stack1.func_190918_g(1);
                        this.fluidInfused = 0;
                        this.fluidtank.extract(this.fluidTotal - this.fluidInfused);
                    }
                }
            } else {
                this.fluidInfused = 0;
                this.fluidTotal = recipe.getBiomass();
                this.output = recipe.getOutput();
            }
        }
        this.doFluidLoop();
    }

    private InfuserRecipe getOutputRecipe() {
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)this.itemhandler, 1, 1);
        InfuserRecipe recipe = (InfuserRecipe)this.field_145850_b.func_199532_z().getRecipe((IInventory)wrapper, this.field_145850_b, ModRecipeTypes.INFUSING);
        return recipe;
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(2, 2) * 4;
    }

    public int fluidPerTick() {
        return 5 + this.getUpgradeTier(2, 2) * 3;
    }

    @Override
    public String getNameString() {
        return "infuser";
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tickspassed", this.fluidInfused);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.fluidInfused = compound.func_74762_e("tickspassed");
        super.func_145839_a(compound);
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerInfuser(playerInventory, this);
    }

    @Override
    public int func_174887_a_(int id) {
        if (id < 4) {
            return super.func_174887_a_(id);
        }
        switch (id) {
            case 4: {
                return this.fluidInfused;
            }
            case 5: {
                return this.fluidTotal;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id < 4) {
            super.func_174885_b(id, value);
        } else {
            switch (id) {
                case 4: {
                    this.fluidInfused = value;
                    break;
                }
                case 5: {
                    this.fluidTotal = value;
                }
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 6;
    }

    @Override
    protected int getFluidInSlot() {
        return 3;
    }

    @Override
    protected int getFluidOutSlot() {
        return 4;
    }
}

