/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.container.ContainerMegaFurnace;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.TileEntityEnergyInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;

public class TileEntityMegaFurnace
extends TileEntityEnergyInventory {
    public int[] ticksPassed = new int[6];
    boolean isSmelting;

    public TileEntityMegaFurnace() {
        super(ModTileEntities.MEGAFURNACE_TE, 10000, 13);
    }

    @Override
    public void doUpdate() {
        this.isSmelting = false;
        for (int i = 0; i < 6; ++i) {
            if (this.energystorage.getEnergyStored() <= this.getEnergyPerTickPerItem()) {
                // empty if block
            }
            if (this.canSmelt(i)) {
                this.isSmelting = true;
                int n = i;
                this.ticksPassed[n] = this.ticksPassed[n] + 1;
                if (this.ticksPassed[i] < this.getTicksPerItem()) continue;
                this.smeltItem(i);
                this.ticksPassed[i] = 0;
                continue;
            }
            if (this.ticksPassed[i] <= 0) continue;
            this.ticksPassed[i] = 0;
        }
        if (this.isSmelting) {
            // empty if block
        }
    }

    private boolean canSmelt(int slot) {
        ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack output = new ItemStack((IItemProvider)Items.field_151044_h);
        if (output.func_190926_b()) {
            return false;
        }
        ItemStack outputslot = this.itemhandler.getStackInSlot(slot + 6);
        if (outputslot.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(outputslot)) {
            return false;
        }
        if (outputslot.func_190916_E() + output.func_190916_E() <= 64 && outputslot.func_190916_E() + output.func_190916_E() <= outputslot.func_77976_d()) {
            return true;
        }
        return outputslot.func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    public void smeltItem(int slot) {
        if (this.canSmelt(slot)) {
            ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
            ItemStack itemstack1 = new ItemStack((IItemProvider)Items.field_151044_h);
            ItemStack itemstack2 = this.itemhandler.getStackInSlot(slot + 6);
            if (itemstack2.func_190926_b()) {
                this.itemhandler.setStackInSlot(slot + 6, itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            itemstack.func_190918_g(1);
        }
    }

    public int getEnergyPerTickPerItem() {
        return 4 + this.getUpgradeTier(12, 2) * 4;
    }

    public int getTicksPerItem() {
        return 200 - this.getUpgradeTier(12, 2) * 35;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        for (int i = 0; i < 6; ++i) {
            compound.func_74768_a("cooktime_" + i, this.ticksPassed[i]);
        }
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        for (int i = 0; i < 6; ++i) {
            this.ticksPassed[i] = compound.func_74762_e("cooktime_" + i);
        }
        super.func_145839_a(compound);
    }

    @Override
    public String getNameString() {
        return "megafurnace";
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return super.func_174887_a_(id);
            }
            case 2: {
                return this.ticksPassed[0];
            }
            case 3: {
                return this.ticksPassed[1];
            }
            case 4: {
                return this.ticksPassed[2];
            }
            case 5: {
                return this.ticksPassed[3];
            }
            case 6: {
                return this.ticksPassed[4];
            }
            case 7: {
                return this.ticksPassed[5];
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: 
            case 1: {
                super.func_174885_b(id, value);
                break;
            }
            case 2: {
                this.ticksPassed[0] = value;
                break;
            }
            case 3: {
                this.ticksPassed[1] = value;
                break;
            }
            case 4: {
                this.ticksPassed[2] = value;
                break;
            }
            case 5: {
                this.ticksPassed[3] = value;
                break;
            }
            case 6: {
                this.ticksPassed[4] = value;
                break;
            }
            case 7: {
                this.ticksPassed[5] = value;
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 8;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerMegaFurnace(playerInventory, this);
    }
}

