/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.blocks.BlockCropBase;
import net.kaneka.planttech2.container.ContainerPlantFarm;
import net.kaneka.planttech2.items.ItemWithTier;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.TileEntityCrops;
import net.kaneka.planttech2.tileentity.machine.baseclasses.TileEntityEnergyInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class TileEntityPlantFarm
extends TileEntityEnergyInventory {
    private int actualX = 0;
    private int actualY = 0;

    public TileEntityPlantFarm() {
        super(ModTileEntities.PLANTFARM_TE, 100000, 17);
    }

    @Override
    public void doUpdate() {
        if ((float)this.field_145850_b.func_82737_E() % (400.0f - (float)this.getSpeedReduction() * 45.0f) == 0.0f) {
            ++this.actualX;
            int range = this.getRange();
            int diameter = range * 2 + 1;
            if (this.actualX >= diameter) {
                this.actualX = 0;
                ++this.actualY;
                if (this.actualY >= diameter) {
                    this.actualY = 0;
                }
            }
            if (this.energystorage.getEnergyStored() < this.getEnergyPerAction()) {
                // empty if block
            }
            BlockPos actualPos = this.field_174879_c.func_177982_a(this.actualX - range, 0, this.actualY - range);
            IBlockState state = this.field_145850_b.func_180495_p(actualPos);
            if (this.field_145850_b.func_180495_p(actualPos).func_177230_c() instanceof BlockCropBase && (Integer)state.func_177229_b((IProperty)BlockCropBase.GROWSTATE) > 6) {
                NonNullList drops = NonNullList.func_191196_a();
                TileEntity te = this.field_145850_b.func_175625_s(actualPos);
                if (te instanceof TileEntityCrops) {
                    ((TileEntityCrops)te).dropsRemoveOneSeed((NonNullList<ItemStack>)drops, 7);
                    for (ItemStack stack : drops) {
                        for (int i = 0; i < 15; ++i) {
                            if (stack.func_190926_b()) continue;
                            stack = this.itemhandler.insertItem(i, stack, false);
                        }
                        if (stack.func_190926_b()) continue;
                        TileEntityPlantFarm.spawnAsEntity(this.field_145850_b, this.field_174879_c.func_177984_a(), stack);
                    }
                    this.field_145850_b.func_175656_a(actualPos, (IBlockState)state.func_206870_a((IProperty)BlockCropBase.GROWSTATE, (Comparable)Integer.valueOf(0)));
                }
            }
        }
    }

    private int getEnergyPerAction() {
        return 20 + 40 * (this.getSpeedReduction() + this.getRange());
    }

    private int getSpeedReduction() {
        ItemWithTier item;
        ItemStack stack = this.itemhandler.getStackInSlot(16);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWithTier && (item = (ItemWithTier)stack.func_77973_b()).getItemType() == 2) {
            return item.getTier();
        }
        return 0;
    }

    private int getRange() {
        ItemWithTier item;
        ItemStack stack = this.itemhandler.getStackInSlot(15);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWithTier && (item = (ItemWithTier)stack.func_77973_b()).getItemType() == 1) {
            return item.getTier() + 1;
        }
        return 1;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("actualx", this.actualX);
        compound.func_74768_a("actualY", this.actualY);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.actualX = compound.func_74762_e("actualx");
        this.actualY = compound.func_74762_e("actualy");
        super.func_145839_a(compound);
    }

    @Override
    public String getNameString() {
        return "plantfarm";
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerPlantFarm(playerInventory, this);
    }
}

