/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.container.ContainerSeedconstructor;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.TileEntityEnergyInventoryFluid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;

public class TileEntitySeedconstructor
extends TileEntityEnergyInventoryFluid {
    private int ticksPassed = 0;

    public TileEntitySeedconstructor() {
        super(ModTileEntities.SEEDCONSTRUCTOR_TE, 1000, 5, 5000);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() <= this.energyPerTick()) {
            // empty if block
        }
        ItemStack stack1 = this.itemhandler.getStackInSlot(0);
        ItemStack stack2 = this.itemhandler.getStackInSlot(1);
        if (!stack1.func_190926_b() && stack2.func_190926_b() && stack1.func_77973_b() == ModItems.DNA_CONTAINER && stack1.func_77942_o() && this.fluidtank.getBiomass() >= this.fluidPerItem()) {
            if (this.ticksPassed < this.ticksPerItem()) {
                ++this.ticksPassed;
            } else {
                this.ticksPassed = 0;
                NBTTagCompound nbt = stack1.func_77978_p();
                HashMapCropTraits traits = new HashMapCropTraits();
                traits.setAnalysed(true);
                if (nbt.func_74764_b("type")) {
                    traits.setType(nbt.func_74779_i("type"));
                }
                for (String key : HashMapCropTraits.getTraitsKeyList()) {
                    if (!nbt.func_74764_b(key) || key.equals("type")) continue;
                    traits.setTrait(EnumTraitsInt.getByName(key), nbt.func_74762_e(key));
                }
                ItemStack stack = new ItemStack((IItemProvider)ModItems.SEEDS.get(traits.getType()));
                this.itemhandler.setStackInSlot(1, traits.addToItemStack(stack));
                this.fluidtank.extract(this.fluidPerItem());
            }
        }
        this.doFluidLoop();
    }

    public int fluidPerItem() {
        return 500;
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(2, 2) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(2, 2) * 35;
    }

    @Override
    public String getNameString() {
        return "seedconstructor";
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tickspassed", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.ticksPassed = compound.func_74762_e("tickspassed");
        super.func_145839_a(compound);
    }

    @Override
    public int func_174887_a_(int id) {
        if (id < 4) {
            return super.func_174887_a_(id);
        }
        switch (id) {
            case 4: {
                return this.ticksPassed;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id < 4) {
            super.func_174885_b(id, value);
        } else {
            switch (id) {
                case 4: {
                    this.ticksPassed = value;
                }
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 5;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerSeedconstructor(playerInventory, this);
    }

    @Override
    protected int getFluidInSlot() {
        return 3;
    }

    @Override
    protected int getFluidOutSlot() {
        return 4;
    }
}

