/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class TileEntityEnergy
extends TileEntity
implements ITickable,
IInteractionObject {
    protected BioEnergyStorage energystorage;
    private LazyOptional<IEnergyStorage> energyCap;
    public String customname;

    public TileEntityEnergy(TileEntityType<?> type, int energyStorage) {
        super(type);
        this.energystorage = new BioEnergyStorage(energyStorage);
        this.energyCap = LazyOptional.of(() -> this.energystorage);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.doUpdate();
        }
    }

    public void doUpdate() {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("energy", (INBTBase)this.energystorage.serializeNBT());
        super.func_189515_b(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energystorage.deserializeNBT(compound.func_74775_l("energy"));
    }

    public String getNameString() {
        return "default";
    }

    public int getEnergyStored() {
        return this.energystorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energystorage.getMaxEnergyStored();
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void onSlotContentChanged() {
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.energystorage.getEnergyStored();
            }
            case 1: {
                return this.energystorage.getMaxEnergyStored();
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.energystorage.setEnergyStored(value);
                break;
            }
            case 1: {
                this.energystorage.setEnergyMaxStored(value);
            }
        }
    }

    public int getAmountFields() {
        return 2;
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation("container." + this.getNameString(), new Object[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_200201_e() {
        return null;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return null;
    }

    public String func_174875_k() {
        return this.func_200662_C().getRegistryName().toString();
    }
}

