/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.items.ItemWithTier;
import net.kaneka.planttech2.tileentity.machine.baseclasses.TileEntityEnergy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityEnergyInventory
extends TileEntityEnergy
implements IInventory {
    protected ItemStackHandler itemhandler;
    private LazyOptional<IItemHandler> inventoryCap;

    public TileEntityEnergyInventory(TileEntityType<?> type, int energyStorage, int invSize) {
        super(type, energyStorage);
        this.itemhandler = new ItemStackHandler(invSize);
        this.inventoryCap = LazyOptional.of(() -> this.itemhandler);
    }

    public List<ItemStack> getInventoryContent() {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemhandler.getSlots(); ++i) {
            stack.add(this.itemhandler.getStackInSlot(i).func_77946_l());
        }
        return stack;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (INBTBase)this.itemhandler.serializeNBT());
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        int slotamount = this.itemhandler.getSlots();
        this.itemhandler.deserializeNBT(compound.func_74775_l("inventory"));
        if (this.itemhandler.getSlots() != slotamount) {
            this.itemhandler.setSize(slotamount);
        }
        super.func_145839_a(compound);
    }

    public static void spawnAsEntity(World worldIn, BlockPos pos, ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_82766_b("doTileDrops") && !worldIn.restoringBlockSnapshots) {
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            entityitem.func_174869_p();
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public int getUpgradeTier(int slot, int itemtype) {
        ItemWithTier item;
        ItemStack stack = this.itemhandler.getStackInSlot(slot);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWithTier && (item = (ItemWithTier)stack.func_77973_b()).getItemType() == itemtype) {
            return item.getTier();
        }
        return 0;
    }

    public int func_70302_i_() {
        return this.itemhandler.getSlots();
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70301_a(int index) {
        return this.itemhandler.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.itemhandler.getStackInSlot(index).func_190918_g(count);
        return this.itemhandler.getStackInSlot(index);
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.itemhandler.getStackInSlot(index).func_77946_l();
        this.itemhandler.setStackInSlot(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.itemhandler.setStackInSlot(index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174890_g() {
        return this.getAmountFields();
    }

    public void func_174888_l() {
        for (int i = 0; i < this.itemhandler.getSlots(); ++i) {
            this.itemhandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }
}

