/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import net.kaneka.planttech2.fluids.TempFluidTank;
import net.kaneka.planttech2.items.ItemBiomassContainer;
import net.kaneka.planttech2.tileentity.machine.baseclasses.TileEntityEnergyInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityType;

public abstract class TileEntityEnergyInventoryFluid
extends TileEntityEnergyInventory {
    protected TempFluidTank fluidtank;

    public TileEntityEnergyInventoryFluid(TileEntityType<?> type, int energyStorage, int invSize, int fluidtanksize) {
        super(type, energyStorage, invSize);
        this.fluidtank = new TempFluidTank(fluidtanksize);
    }

    public void doFluidLoop() {
        ItemStack stack = this.itemhandler.getStackInSlot(this.getFluidInSlot());
        ItemStack stack2 = this.itemhandler.getStackInSlot(this.getFluidOutSlot());
        if (stack != null && stack.func_77973_b() instanceof ItemBiomassContainer) {
            this.fluidtank.receive(((ItemBiomassContainer)stack.func_77973_b()).extractFillLevel(stack, 4));
        }
        if (stack2 != null && stack2.func_77973_b() instanceof ItemBiomassContainer) {
            this.fluidtank.extract(((ItemBiomassContainer)stack2.func_77973_b()).receiveFillLevel(stack2, 4));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("fluidtank", (INBTBase)this.fluidtank.serializeNBT());
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.fluidtank.deserializeNBT(compound.func_74775_l("fluidtank"));
        super.func_145839_a(compound);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return super.func_174887_a_(id);
            }
            case 2: {
                return this.fluidtank.getBiomass();
            }
            case 3: {
                return this.fluidtank.getCapacity();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: 
            case 1: {
                super.func_174885_b(id, value);
                break;
            }
            case 2: {
                this.fluidtank.setBiomass(value);
                break;
            }
            case 3: {
                this.fluidtank.setCapacity(value);
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 4;
    }

    protected abstract int getFluidInSlot();

    protected abstract int getFluidOutSlot();
}

