/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.machines;

import java.util.List;
import net.kaneka.planttech2.blocks.baseclasses.BaseBlock;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.tileentity.machine.ChipalyzerTileEntity;
import net.kaneka.planttech2.tileentity.machine.CompressorTileEntity;
import net.kaneka.planttech2.tileentity.machine.DNACleanerTileEntity;
import net.kaneka.planttech2.tileentity.machine.DNACombinerTileEntity;
import net.kaneka.planttech2.tileentity.machine.DNAExtractorTileEntity;
import net.kaneka.planttech2.tileentity.machine.DNARemoverTileEntity;
import net.kaneka.planttech2.tileentity.machine.EnergyStorageTileEntity;
import net.kaneka.planttech2.tileentity.machine.EnergySupplierTileEntity;
import net.kaneka.planttech2.tileentity.machine.IdentifierTileEntity;
import net.kaneka.planttech2.tileentity.machine.InfuserTileEntity;
import net.kaneka.planttech2.tileentity.machine.MachineBulbReprocessorTileEntity;
import net.kaneka.planttech2.tileentity.machine.MegaFurnaceTileEntity;
import net.kaneka.planttech2.tileentity.machine.PlantFarmTileEntity;
import net.kaneka.planttech2.tileentity.machine.PlantTopiaTeleporterTileEntity;
import net.kaneka.planttech2.tileentity.machine.SeedSqueezerTileEntity;
import net.kaneka.planttech2.tileentity.machine.SeedconstructorTileEntity;
import net.kaneka.planttech2.tileentity.machine.SolarGeneratorTileEntity;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MachineBaseBlock
extends BaseBlock {
    public MachineBaseBlock(String name, ItemGroup group) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 10.0f).func_226896_b_(), name, group, true, true);
    }

    public IItemProvider getItemDropped(BlockState state, World worldIn, BlockPos pos, int fortune) {
        return this;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)this);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof EnergyTileEntity) {
            ((ServerPlayerEntity)player).func_213829_a((INamedContainerProvider)((EnergyTileEntity)te));
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (this == ModBlocks.IDENTIFIER) {
            return new IdentifierTileEntity();
        }
        if (this == ModBlocks.MEGAFURNACE) {
            return new MegaFurnaceTileEntity();
        }
        if (this == ModBlocks.PLANTFARM) {
            return new PlantFarmTileEntity();
        }
        if (this == ModBlocks.SOLARGENERATOR) {
            return new SolarGeneratorTileEntity();
        }
        if (this == ModBlocks.SEEDSQUEEZER) {
            return new SeedSqueezerTileEntity();
        }
        if (this == ModBlocks.DNA_COMBINER) {
            return new DNACombinerTileEntity();
        }
        if (this == ModBlocks.DNA_EXTRACTOR) {
            return new DNAExtractorTileEntity();
        }
        if (this == ModBlocks.DNA_REMOVER) {
            return new DNARemoverTileEntity();
        }
        if (this == ModBlocks.SEEDCONSTRUCTOR) {
            return new SeedconstructorTileEntity();
        }
        if (this == ModBlocks.DNA_CLEANER) {
            return new DNACleanerTileEntity();
        }
        if (this == ModBlocks.COMPRESSOR) {
            return new CompressorTileEntity();
        }
        if (this == ModBlocks.ENERGYSTORAGE) {
            return new EnergyStorageTileEntity();
        }
        if (this == ModBlocks.INFUSER) {
            return new InfuserTileEntity();
        }
        if (this == ModBlocks.CHIPALYZER) {
            return new ChipalyzerTileEntity();
        }
        if (this == ModBlocks.PLANTTOPIA_TELEPORTER) {
            return new PlantTopiaTeleporterTileEntity();
        }
        if (this == ModBlocks.MACHINEBULBREPROCESSOR) {
            return new MachineBulbReprocessorTileEntity();
        }
        if (this == ModBlocks.ENERGY_SUPPLIER) {
            return new EnergySupplierTileEntity();
        }
        return new IdentifierTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            if (worldIn.func_175625_s(pos) instanceof EnergyInventoryTileEntity) {
                EnergyInventoryTileEntity te = (EnergyInventoryTileEntity)worldIn.func_175625_s(pos);
                List<ItemStack> toSpawn = te.getInventoryContent();
                for (ItemStack stack : toSpawn) {
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
                }
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int tier = 0;
        if (this == ModBlocks.IDENTIFIER) {
            tier = 1;
        } else if (this == ModBlocks.MEGAFURNACE) {
            tier = 3;
        } else if (this == ModBlocks.PLANTFARM) {
            tier = 5;
        } else if (this == ModBlocks.SOLARGENERATOR) {
            tier = 5;
        } else if (this == ModBlocks.SEEDSQUEEZER) {
            tier = 0;
        } else if (this == ModBlocks.DNA_COMBINER) {
            tier = 4;
        } else if (this == ModBlocks.DNA_EXTRACTOR) {
            tier = 4;
        } else if (this == ModBlocks.DNA_REMOVER) {
            tier = 4;
        } else if (this == ModBlocks.SEEDCONSTRUCTOR) {
            tier = 4;
        } else if (this == ModBlocks.DNA_CLEANER) {
            tier = 4;
        } else if (this == ModBlocks.COMPRESSOR) {
            tier = 1;
        } else if (this == ModBlocks.INFUSER) {
            tier = 2;
        } else if (this == ModBlocks.CHIPALYZER) {
            tier = 2;
        } else if (this == ModBlocks.MACHINEBULBREPROCESSOR) {
            tier = 0;
        } else if (this == ModBlocks.ENERGY_SUPPLIER) {
            tier = 2;
        }
        tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.tier", new Object[0]).func_150261_e() + ": " + tier));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

