/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.dimensions;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class TeleportationUtils {
    public static void changeDimension(World worldIn, BlockPos pos, PlayerEntity playerIn, DimensionType destDim, Block ... portalBlock) {
        ServerWorld destination = worldIn.func_73046_m().func_71218_a(destDim);
        BlockPos surfacePos = TeleportationUtils.trySpawnPortal((World)destination, pos, destDim, portalBlock);
        TeleportationUtils.changeDim((ServerPlayerEntity)playerIn, surfacePos, destDim);
    }

    private static BlockPos trySpawnPortal(World world, BlockPos pos, DimensionType destDim, Block ... portalBlock) {
        int z;
        int x;
        int y;
        TeleportationUtils.preLoadChunk(world.func_73046_m(), pos.func_177958_n(), pos.func_177952_p(), destDim);
        BlockPos surfacePos = new BlockPos(pos.func_177958_n(), 256, pos.func_177952_p());
        for (int y2 = 0; y2 < 256; ++y2) {
            if (!world.func_180495_p(pos.func_177979_c(y2)).func_200132_m()) continue;
            surfacePos = new BlockPos((Vec3i)pos.func_177979_c(y2 - 2));
            break;
        }
        boolean flag = false;
        if (surfacePos.func_177956_o() < 55) {
            surfacePos = new BlockPos(surfacePos.func_177958_n(), 90, surfacePos.func_177952_p());
            flag = true;
        }
        boolean foundBlock = false;
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable(0, 0, 0);
        for (y = 0; y < 256; ++y) {
            for (x = pos.func_177958_n() - 6; x < pos.func_177958_n() + 6; ++x) {
                block3: for (z = pos.func_177952_p() - 6; z < pos.func_177952_p() + 6; ++z) {
                    mutableBlockPos.func_181079_c(x, y, z);
                    for (int i = 0; i < portalBlock.length; ++i) {
                        if (world.func_180495_p((BlockPos)mutableBlockPos).func_177230_c() != portalBlock[i]) continue;
                        surfacePos = new BlockPos(x, y + 1, z);
                        foundBlock = true;
                        continue block3;
                    }
                }
            }
        }
        if (flag) {
            for (y = -1; y <= 0; ++y) {
                for (x = -2; x <= 2; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        world.func_175656_a(surfacePos.func_177981_b(y).func_177964_d(x).func_177965_g(z), Blocks.field_196658_i.func_176223_P());
                    }
                }
            }
        }
        if (!foundBlock) {
            world.func_175656_a(surfacePos.func_177977_b(), portalBlock[0].func_176223_P());
            world.func_175656_a(surfacePos, Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(surfacePos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        }
        return surfacePos;
    }

    private static void changeDim(ServerPlayerEntity player, BlockPos pos, DimensionType type) {
        if (!ForgeHooks.onTravelToDimension((Entity)player, (DimensionType)type)) {
            return;
        }
        DimensionType dimensiontype = player.field_71093_bK;
        ServerWorld serverworld = player.field_71133_b.func_71218_a(dimensiontype);
        player.field_71093_bK = type;
        ServerWorld serverworld1 = player.field_71133_b.func_71218_a(type);
        WorldInfo worldinfo = player.field_70170_p.func_72912_H();
        player.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(type, 0L, worldinfo.func_76067_t(), player.field_71134_c.func_73081_b()));
        player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = player.field_71133_b.func_184103_al();
        playerlist.func_187243_f(player);
        serverworld.removeEntity((Entity)player, true);
        player.revive();
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        player.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, f1, f);
        serverworld.func_217381_Z().func_76319_b();
        serverworld.func_217381_Z().func_76320_a("placing");
        player.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, f1, f);
        serverworld.func_217381_Z().func_76319_b();
        player.func_70029_a((World)serverworld1);
        serverworld1.func_217447_b(player);
        player.field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, f1, f);
        player.field_71134_c.func_73080_a(serverworld1);
        player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        playerlist.func_72354_b(player, serverworld1);
        playerlist.func_72385_f(player);
        for (EffectInstance effectinstance : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectinstance));
        }
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)player, (DimensionType)dimensiontype, (DimensionType)type);
    }

    private static boolean preLoadChunk(MinecraftServer server, int x, int z, DimensionType dimensionID) {
        ServerChunkProvider chunkProvider = server.func_71218_a(dimensionID).func_72863_F();
        if (chunkProvider.func_73149_a(x, z)) {
            return false;
        }
        chunkProvider.func_217205_a(x, z, true);
        return true;
    }
}

