/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.dimensions.planttopia;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.function.LongFunction;
import net.kaneka.planttech2.dimensions.planttopia.layers.GenLayerBiomes;
import net.kaneka.planttech2.registries.ModStructures;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class PlantTopiaBiomeProvider
extends BiomeProvider {
    private final Layer genLayer;
    public static final List<Biome> SPAWNS = Lists.newArrayList((Object[])new Biome[]{Biomes.field_76772_c});
    private static final Set<Biome> BIOMES = ImmutableSet.of((Object)Biomes.field_76772_c, (Object)Biomes.field_150583_P, (Object)Biomes.field_76769_d);

    protected PlantTopiaBiomeProvider(long seed) {
        super(BIOMES);
        this.field_205005_a.put(ModStructures.TECHVILLAGE, true);
        this.genLayer = PlantTopiaBiomeProvider.genLayers(seed);
    }

    private static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> genLayers(LongFunction<C> seed) {
        IAreaFactory<T> biomes = new GenLayerBiomes().func_202823_a((IExtendedNoiseRandom)seed.apply(1L));
        biomes = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)seed.apply(2000L), (IAreaFactory)biomes);
        biomes = PlantTopiaBiomeProvider.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, biomes, 6, seed);
        return biomes;
    }

    public static Layer genLayers(long seed) {
        IAreaFactory areaFactory = PlantTopiaBiomeProvider.genLayers(context -> new LazyAreaLayerContext(25, seed, context));
        return new Layer(areaFactory);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> p_202829_3_, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = p_202829_3_;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public List<Biome> func_76932_a() {
        return SPAWNS;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.genLayer.func_215738_a(x, z);
    }
}

