/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.dimensions.planttopia.biomes;

import net.kaneka.planttech2.dimensions.planttopia.biomes.BiomeRadiation;
import net.kaneka.planttech2.dimensions.planttopia.biomes.PlantTopiaBiomeDecorator;
import net.kaneka.planttech2.dimensions.structure.tech.TechVillageConfig;
import net.kaneka.planttech2.registries.ModBiomes;
import net.kaneka.planttech2.registries.ModStructures;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public abstract class PlantTopiaBaseBiome
extends Biome {
    private BiomeManager.BiomeType biomeType;
    private BiomeDictionary.Type[] biomDictType;

    public PlantTopiaBaseBiome(Biome.Builder biomeBuilder, BiomeRarity rarity, ResourceLocation resLoc, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... biomDictType) {
        super(biomeBuilder);
        this.biomeType = biomeType;
        this.biomDictType = biomDictType;
        this.setRegistryName(resLoc);
        ModBiomes.BIOMES.add(this);
        if (rarity.equals((Object)BiomeRarity.COMMON)) {
            ModBiomes.COMMON_BIOMES.add(this);
        } else if (rarity.equals((Object)BiomeRarity.UNCOMMON)) {
            ModBiomes.UNCOMMON_BIOMES.add(this);
        } else if (rarity.equals((Object)BiomeRarity.RARE)) {
            ModBiomes.RARE_BIOMES.add(this);
        }
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ModStructures.TECHVILLAGE.func_225566_b_((IFeatureConfig)new TechVillageConfig("planttech2:village/tech/starts", 6)));
        this.func_226711_a_(ModStructures.TECHVILLAGE.func_225566_b_((IFeatureConfig)new TechVillageConfig("planttech2:village/tech/starts", 6)));
        PlantTopiaBiomeDecorator.addCrystalOres(this);
        PlantTopiaBiomeDecorator.addBiomassLake(this);
    }

    public BiomeManager.BiomeType getBiomeType() {
        return this.biomeType;
    }

    public BiomeDictionary.Type[] getBiomeDictionaryType() {
        return this.biomDictType;
    }

    public float getFogDensity() {
        return -1.0f;
    }

    public abstract BiomeRadiation getRadiationLevel();

    public float[] getFogRGB() {
        return new float[]{-1.0f, -1.0f, -1.0f};
    }

    public float getFogRed() {
        return this.getFogRGB()[0];
    }

    public float getFogGreen() {
        return this.getFogRGB()[1];
    }

    public float getFogBlue() {
        return this.getFogRGB()[2];
    }

    public static enum BiomeRarity {
        COMMON(0),
        UNCOMMON(1),
        RARE(2);

        int id;

        private BiomeRarity(int id) {
            this.id = id;
        }
    }
}

