/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.passive;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.kaneka.planttech2.entities.tradesandjobs.TechVillagerContainerProvider;
import net.kaneka.planttech2.entities.tradesandjobs.TechVillagerTrade;
import net.kaneka.planttech2.entities.tradesandjobs.TechVillagerTradePool;
import net.kaneka.planttech2.entities.tradesandjobs.TechVillagerTradePools;
import net.kaneka.planttech2.registries.ModEntityTypes;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TechVillagerEntity
extends AgeableEntity {
    public static final int SCIENTIST = 0;
    public static final int BOTANIST = 1;
    public static final int HEADHUNTER = 2;
    public static final int ENGINEER = 3;
    private static final DataParameter<Integer> PROFESSION = EntityDataManager.func_187226_a(TechVillagerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private List<TechVillagerTrade> offers;

    public TechVillagerEntity(EntityType<? extends TechVillagerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROFESSION, (Object)0);
    }

    public int getProfession() {
        return (Integer)this.field_70180_af.func_187225_a(PROFESSION);
    }

    public static String getProfessionString(int profession) {
        switch (profession) {
            case 0: {
                return "scientist";
            }
            case 1: {
                return "botanist";
            }
            case 2: {
                return "headhunter";
            }
            case 3: {
                return "engineer";
            }
        }
        return "scientist";
    }

    private List<TechVillagerTrade> getOffers() {
        if (this.offers == null) {
            this.offers = new ArrayList<TechVillagerTrade>();
            this.populateTrades();
        } else if (this.offers.size() == 0) {
            this.populateTrades();
        }
        return this.offers;
    }

    private void populateTrades() {
        List<TechVillagerTradePool> pool = TechVillagerTradePools.getSCIENTISTS();
        ArrayList<Integer> integers = new ArrayList<Integer>();
        for (int i = 0; i < pool.size(); ++i) {
            integers.add(i);
        }
        Random rand = new Random();
        for (int i = 0; i < Math.min(8, pool.size()); ++i) {
            int randomint = rand.nextInt(integers.size());
            this.offers.add(pool.get((Integer)integers.get(randomint)).generateTechVillagerTrade());
            integers.remove(randomint);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.offers = new ArrayList<TechVillagerTrade>();
        for (int i = 0; i < compound.func_74762_e("length_trades"); ++i) {
            this.offers.add(TechVillagerTrade.fromNBT(compound.func_74775_l("offer_" + i)));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.offers != null) {
            compound.func_74768_a("length_trades", this.offers.size());
            for (int i = 0; i < this.offers.size(); ++i) {
                compound.func_218657_a("offer_" + i, (INBT)this.offers.get(i).toNBT());
            }
        } else {
            compound.func_74768_a("length_trades", 0);
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND && !this.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new TechVillagerContainerProvider(this.getOffers(), this.getProfession()), buffer -> {
                buffer.writeInt(this.getProfession());
                buffer.writeInt(this.offers.size());
                for (TechVillagerTrade trade : this.offers) {
                    trade.toBuffer((PacketBuffer)buffer);
                }
            });
        }
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public static EntityType<? extends TechVillagerEntity> getEntityType() {
        return ModEntityTypes.TECHVILLAGERENTITY;
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return new TechVillagerEntity(TechVillagerEntity.getEntityType(), this.field_70170_p);
    }
}

