/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.events;

import java.util.Arrays;
import net.kaneka.planttech2.dimensions.planttopia.biomes.PlantTopiaBaseBiome;
import net.kaneka.planttech2.entities.capabilities.player.IPlayerRenderRGB;
import net.kaneka.planttech2.entities.capabilities.player.PlayerRenderRGB;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModDimensions;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    public static boolean hasSendUpdateAvailable = false;

    @SubscribeEvent
    public static void registerColorItem(ColorHandlerEvent.Item event) {
        ModItems.registerItemColorHandler(event);
    }

    @SubscribeEvent
    public static void registerColorBlock(ColorHandlerEvent.Block event) {
        ModBlocks.registerBlockColorHandler(event);
    }

    @SubscribeEvent
    public static void onWorldStart(EntityJoinWorldEvent evt) {
        VersionChecker.CheckResult res = VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerById("planttech2").get()).getModInfo());
        if (evt.getEntity() instanceof ClientPlayerEntity && res.status == VersionChecker.Status.OUTDATED && !hasSendUpdateAvailable) {
            hasSendUpdateAvailable = true;
            TranslationTextComponent info = new TranslationTextComponent("planttech2.update.available", new Object[0]);
            TranslationTextComponent link = new TranslationTextComponent("planttech2.update.click", new Object[0]);
            link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/planttech-2/files")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("planttech2.update.tooltip", new Object[0]))).func_150238_a(TextFormatting.BLUE).func_150228_d(Boolean.valueOf(true));
            evt.getEntity().func_145747_a(info.func_150257_a((ITextComponent)link));
        }
    }

    @SubscribeEvent
    public static void onFogRenderDensity(EntityViewRenderEvent.FogDensity event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null || !player.func_70089_S() || player.func_130014_f_().func_201675_m().func_186058_p() != ModDimensions.getPlantTopiaDimensionType()) {
            return;
        }
        Biome biome = player.func_130014_f_().func_226691_t_(player.func_180425_c());
        if (!(biome instanceof PlantTopiaBaseBiome)) {
            return;
        }
        float biomeDencity = ((PlantTopiaBaseBiome)biome).getFogDensity();
        IPlayerRenderRGB capability = PlayerRenderRGB.getCap((PlayerEntity)player);
        if (biomeDencity != -1.0f && Math.abs(capability.getCurrentFogDensity() - biomeDencity) > 1.0E-5f) {
            event.setCanceled(true);
            capability.setCurrentFogDensity(capability.getCurrentFogDensity() + (capability.getCurrentFogDensity() < biomeDencity ? 1.0E-5f : -1.0E-5f));
            event.setDensity(capability.getCurrentFogDensity());
        } else if (Math.abs(capability.getCurrentFogDensity() - biomeDencity) < 1.0E-5f) {
            event.setCanceled(true);
            event.setDensity(biomeDencity);
        }
    }

    @SubscribeEvent
    public static void onFogRenderColour(EntityViewRenderEvent.FogColors event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null || !player.func_70089_S()) {
            return;
        }
        IPlayerRenderRGB capability = PlayerRenderRGB.getCap((PlayerEntity)player);
        Biome biome = player.func_130014_f_().func_226691_t_(player.func_180425_c());
        float[] targetRGB = new float[]{event.getRed(), event.getGreen(), event.getBlue()};
        if (biome instanceof PlantTopiaBaseBiome && !Arrays.equals(((PlantTopiaBaseBiome)biome).getFogRGB(), new float[]{-1.0f, -1.0f, -1.0f})) {
            targetRGB[0] = ((PlantTopiaBaseBiome)biome).getFogRed() / 255.0f;
            targetRGB[1] = ((PlantTopiaBaseBiome)biome).getFogGreen() / 255.0f;
            targetRGB[2] = ((PlantTopiaBaseBiome)biome).getFogBlue() / 255.0f;
        }
        if (Math.abs(capability.getCurrentRed() - targetRGB[0]) > 0.001f) {
            capability.changeCurrentRed(capability.getCurrentRed() < targetRGB[0] ? 0.001f : -0.001f);
            event.setRed(capability.getCurrentRed());
        } else {
            event.setRed(targetRGB[0]);
        }
        if (Math.abs(capability.getCurrentGreen() - targetRGB[1]) > 0.001f) {
            capability.changeCurrentGreen(capability.getCurrentGreen() < targetRGB[1] ? 0.001f : -0.001f);
            event.setGreen(capability.getCurrentGreen());
        } else {
            event.setGreen(targetRGB[1]);
        }
        if (Math.abs(capability.getCurrentBlue() - targetRGB[2]) > 0.001f) {
            capability.changeCurrentBlue(capability.getCurrentBlue() < targetRGB[2] ? 0.001f : -0.001f);
            event.setBlue(capability.getCurrentBlue());
        } else {
            event.setBlue(targetRGB[2]);
        }
    }
}

