/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.events;

import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.dimensions.planttopia.biomes.BiomeRadiation;
import net.kaneka.planttech2.dimensions.planttopia.biomes.PlantTopiaBaseBiome;
import net.kaneka.planttech2.entities.IAffectPlayerRadiation;
import net.kaneka.planttech2.entities.capabilities.player.IPlayerRenderRGB;
import net.kaneka.planttech2.entities.capabilities.player.IRadiationEffect;
import net.kaneka.planttech2.entities.capabilities.player.PlayerRenderRGB;
import net.kaneka.planttech2.entities.capabilities.player.RadiationEffect;
import net.kaneka.planttech2.packets.CropConfigChangeMessage;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.kaneka.planttech2.packets.SyncRadiationLevelMessage;
import net.kaneka.planttech2.registries.ModDimensions;
import net.kaneka.planttech2.registries.ModEffects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="planttech2")
public class PlayerEvents {
    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player;
        if (event.getEntity() instanceof ServerPlayerEntity && !event.getEntity().func_130014_f_().func_201670_d()) {
            player = (ServerPlayerEntity)event.getPlayer();
            PlayerEvents.syncRadiationCapWithClient(player);
            PlantTech2PacketHandler.sendTo(new CropConfigChangeMessage(PlantTechMain.croplist.getConfigs()), player);
        }
        if (event.getPlayer().func_130014_f_().func_201670_d() && event.getPlayer().func_130014_f_().func_201675_m().func_186058_p() == ModDimensions.getPlantTopiaDimensionType()) {
            player = event.getPlayer();
            IPlayerRenderRGB capability = PlayerRenderRGB.getCap((PlayerEntity)player);
            Biome biome = player.func_130014_f_().func_226691_t_(player.func_180425_c());
            if (biome instanceof PlantTopiaBaseBiome) {
                PlantTopiaBaseBiome pt2biome = (PlantTopiaBaseBiome)biome;
                float[] rgb = new float[]{pt2biome.getFogRed(), pt2biome.getFogGreen(), pt2biome.getFogBlue()};
                capability.setCurrentFogDensity(pt2biome.getFogDensity());
                capability.setRGB(rgb);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && !event.getEntity().func_130014_f_().func_201670_d()) {
            PlayerEvents.syncRadiationCapWithClient((ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && !event.getEntity().func_130014_f_().func_201670_d()) {
            RadiationEffect.getCap((ServerPlayerEntity)player).setLevel(0.0f);
            PlayerEvents.syncRadiationCapWithClient((ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public static void playerTicking(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (player == null || !player.func_70089_S() || !(player instanceof ServerPlayerEntity) || player.func_130014_f_().func_201670_d() || player.field_71075_bZ.field_75098_d) {
            if (player != null && player.func_70660_b(ModEffects.RADIATION_SICKNESS) != null && player.field_71075_bZ.field_75098_d) {
                player.func_195063_d(ModEffects.RADIATION_SICKNESS);
            }
            return;
        }
        Biome biome = player.func_130014_f_().func_226691_t_(player.func_180425_c());
        IRadiationEffect capability = RadiationEffect.getCap((ServerPlayerEntity)player);
        if (biome instanceof PlantTopiaBaseBiome) {
            BiomeRadiation level = ((PlantTopiaBaseBiome)biome).getRadiationLevel();
            if (level == BiomeRadiation.FRESH) {
                capability.decreaseLevel(BiomeRadiation.getDensity(level));
            } else {
                capability.increaseLevel(BiomeRadiation.getDensity(level));
            }
        } else {
            capability.decreaseLevel(9.259259E-6f);
        }
        if (capability.getLevel() >= 1.0f && (player.func_70660_b(ModEffects.RADIATION_SICKNESS) == null || player.func_70660_b(ModEffects.RADIATION_SICKNESS).func_76459_b() <= 33000)) {
            player.func_195064_c(new EffectInstance(ModEffects.RADIATION_SICKNESS, 99999));
        } else if (capability.getLevel() < 1.0f && player.func_70660_b(ModEffects.RADIATION_SICKNESS) != null) {
            player.func_195063_d(ModEffects.RADIATION_SICKNESS);
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && event.getSource().func_76346_g() instanceof IAffectPlayerRadiation && !((PlayerEntity)event.getEntityLiving()).field_71075_bZ.field_75098_d) {
            RadiationEffect.getCap((ServerPlayerEntity)event.getEntityLiving()).increaseLevel(((IAffectPlayerRadiation)event.getSource().func_76346_g()).getAmount());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        IRadiationEffect oldCap = RadiationEffect.getCap((ServerPlayerEntity)event.getOriginal());
        IRadiationEffect newCap = RadiationEffect.getCap((ServerPlayerEntity)event.getEntityLiving());
        if (event.isWasDeath()) {
            newCap.setLevel(oldCap.getLevel());
        } else {
            newCap.setLevel(0.0f);
        }
    }

    private static void syncRadiationCapWithClient(ServerPlayerEntity player) {
        PlantTech2PacketHandler.sendTo(new SyncRadiationLevelMessage(RadiationEffect.getCap(player).getLevel()), player);
    }
}

