/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.fluids.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kaneka.planttech2.fluids.capability.IBiomassFluidEnergy;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BiomassFluidEnergy
implements ICapabilitySerializable<CompoundNBT>,
IBiomassFluidEnergy {
    @CapabilityInject(value=IBiomassFluidEnergy.class)
    public static Capability<IBiomassFluidEnergy> BIOMASS_FLUID_ENERGY = null;
    private final LazyOptional<IBiomassFluidEnergy> lazyOptional = LazyOptional.of(BiomassFluidEnergy::new);
    private int currentStorage = 0;
    private int maxStorage = 1000;

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == BIOMASS_FLUID_ENERGY ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)BIOMASS_FLUID_ENERGY.getStorage().writeNBT(BIOMASS_FLUID_ENERGY, this.lazyOptional.orElseThrow(() -> new NullPointerException("An error has occur during writing Biomass Capability by Plant Tech 2")), null);
    }

    public static IBiomassFluidEnergy getTECap(TileEntity te) {
        return (IBiomassFluidEnergy)te.getCapability(BIOMASS_FLUID_ENERGY).orElseThrow(() -> new NullPointerException("getting capability for tileentity"));
    }

    public static IBiomassFluidEnergy getItemStackCap(ItemStack stack) {
        IBiomassFluidEnergy cap = (IBiomassFluidEnergy)stack.getCapability(BIOMASS_FLUID_ENERGY).orElseThrow(() -> new NullPointerException("getting capability for itemstack"));
        return cap;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        BIOMASS_FLUID_ENERGY.getStorage().readNBT(BIOMASS_FLUID_ENERGY, this.lazyOptional.orElseThrow(() -> new NullPointerException("An error has occur during reading Biomass Capability by Plant Tech 2")), null, (INBT)nbt);
    }

    @Override
    public int getCurrentStorage() {
        return this.currentStorage;
    }

    @Override
    public int getMaxStorage() {
        return this.maxStorage;
    }

    @Override
    public int extractBiomass(int amount) {
        amount = Math.abs(amount);
        if (this.getCurrentStorage() < amount) {
            this.changeCurrentStorage(-this.getCurrentStorage());
            return this.getCurrentStorage();
        }
        this.changeCurrentStorage(-amount);
        return amount;
    }

    @Override
    public void setCurrentStorage(int value) {
        this.currentStorage = value < 0 ? 0 : Math.min(value, this.maxStorage);
    }

    @Override
    public void setMaxStorage(int value) {
        this.maxStorage = value;
    }

    @Override
    public void changeCurrentStorage(int amount) {
        this.currentStorage = this.currentStorage + amount < 0 ? 0 : (this.currentStorage + amount > this.maxStorage ? this.maxStorage : (this.currentStorage += amount));
    }

    @Override
    public int recieveBiomass(int amount) {
        amount = Math.abs(amount);
        this.changeCurrentStorage(Math.abs(amount));
        return -amount;
    }

    @Override
    public void clearStorage() {
        this.currentStorage = 0;
    }

    @Override
    public boolean hasEnoughBiomass(int target) {
        return this.currentStorage >= target;
    }

    public static class BiomassFluidEnergyStorage
    implements Capability.IStorage<IBiomassFluidEnergy> {
        @Nullable
        public INBT writeNBT(Capability<IBiomassFluidEnergy> capability, IBiomassFluidEnergy instance, Direction side) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("maxstorage", instance.getMaxStorage());
            compound.func_74768_a("currentstorage", instance.getCurrentStorage());
            return compound;
        }

        public void readNBT(Capability<IBiomassFluidEnergy> capability, IBiomassFluidEnergy instance, Direction side, INBT nbt) {
            CompoundNBT compound = (CompoundNBT)nbt;
            instance.setMaxStorage(compound.func_74762_e("maxstorage"));
            instance.setCurrentStorage(compound.func_74762_e("currentstorage"));
        }
    }
}

