/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.kaneka.planttech2.container.BaseContainer;
import net.kaneka.planttech2.gui.guide.Guide;
import net.kaneka.planttech2.gui.guide.GuideScreen;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

abstract class BaseContainerScreen<T extends BaseContainer>
extends ContainerScreen<T> {
    protected final PlayerInventory player;
    protected final EnergyTileEntity te;

    protected abstract ResourceLocation getBackgroundTexture();

    public BaseContainerScreen(BaseContainer inventorySlotsIn, PlayerInventory inventoryPlayer, ITextComponent title) {
        super((Container)inventorySlotsIn, inventoryPlayer, title);
        this.te = inventorySlotsIn.getTE();
        this.player = inventoryPlayer;
    }

    public void init() {
        super.init();
        this.field_146999_f = 208;
        this.field_147000_g = 200;
        this.field_147003_i = (this.width - this.field_146999_f) / 2;
        this.field_147009_r = (this.height - this.field_147000_g) / 2;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.drawTooltips(mouseX, mouseY);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        this.drawTooltip(this.te.getEnergyStored() + "/" + this.te.getMaxEnergyStored(), mouseX, mouseY, 148, 27, 16, 55);
    }

    public void drawTooltip(String lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.field_147003_i) && mouseX <= posX + width && mouseY >= (posY += this.field_147009_r) && mouseY <= posY + height) {
            this.renderTooltip(lines, mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.getBackgroundTexture());
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String tileName = this.title.func_150261_e();
        int textcolor = Integer.parseInt("000000", 16);
        this.font.func_211126_b(tileName, (float)(this.field_146999_f / 2 - this.font.func_78256_a(tileName) / 2 + 1), 14.0f, textcolor);
    }

    protected int getEnergyStoredScaled(int pixels) {
        int i = ((BaseContainer)this.field_147002_h).getValue(0);
        int j = ((BaseContainer)this.field_147002_h).getValue(1);
        return i != 0 && j != 0 ? i * pixels / j : 0;
    }

    protected int getFluidStoredScaled(int pixels) {
        int i = ((BaseContainer)this.field_147002_h).getValue(2);
        int j = ((BaseContainer)this.field_147002_h).getValue(3);
        return i != 0 && j != 0 ? i * pixels / j : 0;
    }

    protected void func_191948_b(int x, int y) {
        if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && !this.field_147006_u.func_75216_d() && this.field_147006_u instanceof BaseContainer.SlotItemHandlerWithInfo) {
            this.renderTooltip(new TranslationTextComponent(((BaseContainer.SlotItemHandlerWithInfo)this.field_147006_u).getUsageString(), new Object[0]).func_150261_e(), x, y);
        } else {
            super.func_191948_b(x, y);
        }
    }

    public boolean mouseClicked(double posX, double posY, int buttonid) {
        if (posX - (double)this.field_147003_i >= 190.0 && posX - (double)this.field_147003_i <= 200.0 && posY - (double)this.field_147009_r >= 15.0 && posY - (double)this.field_147009_r <= 26.0) {
            Guide guide = new Guide();
            int menu = guide.getMenuByName(this.getGuideMenuString());
            int entry = guide.getEntryByName(menu, this.getGuideEntryString());
            Minecraft.func_71410_x().func_147108_a((Screen)new GuideScreen(menu, entry));
            return true;
        }
        return super.mouseClicked(posX, posY, buttonid);
    }

    protected String getGuideMenuString() {
        return "machines";
    }

    protected abstract String getGuideEntryString();
}

