/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.kaneka.planttech2.items.GuideItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuideBaseScreen
extends Screen {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2:textures/gui/plantencyclopaedia_big.png");
    protected int xSize = 512;
    protected int ySize = 196;
    protected int guiLeft;
    protected int guiTop;
    protected int scrollMax;
    protected int scrollPos = 0;
    protected int fadeInTimer = 50;
    protected int selectedId;
    protected boolean canscroll;

    public GuideBaseScreen(int scrollMax, boolean canscroll, String title) {
        super((ITextComponent)new TranslationTextComponent(title, new Object[0]));
        this.scrollMax = scrollMax;
        this.canscroll = canscroll;
    }

    public void init() {
        super.init();
        if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof GuideItem) {
            Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_196085_b(1);
        }
        this.selectedId = -1;
        this.guiLeft = (this.width - 400) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
    }

    protected void updateButtons() {
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
        if (this.fadeInTimer > 0) {
            --this.fadeInTimer;
            this.drawFadeInEffect();
        } else {
            this.drawBackground();
            this.drawForeground();
            this.drawButtons(mouseX, mouseY, partialTicks);
            this.drawStrings();
            this.drawTooltips(mouseX, mouseY);
        }
    }

    private void drawButtons(int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            ((Widget)this.buttons.get(i)).render(mouseX, mouseY, partialTicks);
        }
    }

    protected void drawBackground() {
        GuideBaseScreen.blit((int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)0.0f, (int)300, (int)this.ySize, (int)512, (int)512);
        GuideBaseScreen.blit((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (int)512, (int)512);
    }

    protected void drawForeground() {
    }

    private void drawFadeInEffect() {
        float percentage = 1.0f - (float)this.fadeInTimer / 50.0f;
        GuideBaseScreen.blit((int)(this.guiLeft + 100), (int)this.guiTop, (float)((float)this.xSize - 300.0f * percentage), (float)0.0f, (int)((int)(300.0f * percentage)), (int)this.ySize, (int)512, (int)512);
        GuideBaseScreen.blit((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (int)512, (int)512);
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.canscroll && p_mouseScrolled_1_ != 0.0) {
            this.scrollPos += p_mouseScrolled_5_ > 0.0 ? -1 : 1;
            this.scrollPos = Math.max(0, this.scrollPos);
            this.scrollPos = Math.min(this.scrollMax, this.scrollPos);
            this.updateButtons();
        }
        return super.mouseScrolled(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    protected void drawStrings() {
    }

    protected String translateUnformated(String name) {
        return new TranslationTextComponent(name, new Object[0]).func_150261_e();
    }

    protected void drawCenteredString(String string, int posX, int posY) {
        this.font.func_211126_b(string, (float)(posX - this.font.func_78256_a(string) / 2), (float)posY, Integer.parseInt("00e803", 16));
    }

    public void renderItem(ItemStack itemstack, int x, int y) {
        this.itemRenderer.func_180450_b(itemstack, this.guiLeft + x, this.guiTop + y);
    }

    public void drawTooltip(String lines, int mouseX, int mouseY, int posX, int posY) {
        this.drawTooltip(lines, mouseX, mouseY, posX, posY, 16, 16);
    }

    public void drawTooltip(String lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.guiLeft) && mouseX <= posX + width && mouseY >= (posY += this.guiTop) && mouseY <= posY + height) {
            this.renderTooltip(lines, mouseX, mouseY);
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
    }

    public void onClose() {
        if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof GuideItem) {
            Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_196085_b(0);
        }
        super.onClose();
    }
}

