/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import net.kaneka.planttech2.container.MachineBulbReprocessorContainer;
import net.kaneka.planttech2.gui.BaseContainerScreen;
import net.kaneka.planttech2.items.MachineBulbItem;
import net.kaneka.planttech2.packets.ButtonPressMessage;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.tileentity.machine.MachineBulbReprocessorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class MachineBulbReprocessorScreen
extends BaseContainerScreen<MachineBulbReprocessorContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2:textures/gui/container/machinebulbreprocessor.png");

    public MachineBulbReprocessorScreen(MachineBulbReprocessorContainer container, PlayerInventory player, ITextComponent name) {
        super(container, player, name);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int l = this.getCookProgressScaled(32);
        this.blit(this.field_147003_i + 87, this.field_147009_r + 88, 32, 200, l, 10);
        int k = this.getEnergyStoredScaled(55);
        this.blit(this.field_147003_i + 149, this.field_147009_r + 28 + (55 - k), 208, 55 - k, 16, 0 + k);
        int j = this.getFluidStoredScaled(55);
        this.blit(this.field_147003_i + 41, this.field_147009_r + 28 + (55 - j), 224, 55 - j, 16, 0 + j);
        int m = ((MachineBulbReprocessorContainer)this.field_147002_h).getValue(5) - 1;
        if (m >= 0) {
            this.blit(this.field_147003_i + 59 + m % 5 * 18, this.field_147009_r + 27 + m / 5 * 18, 0, 200, 16, 16);
        }
        int n = ((MachineBulbReprocessorContainer)this.field_147002_h).getValue(6);
        int x = 0;
        int y = 0;
        for (MachineBulbItem bulb : ModItems.MACHINEBULBS) {
            Block machine = bulb.getMachine();
            if (machine != null && n < bulb.getTier()) {
                this.blit(this.field_147003_i + 59 + x * 18, this.field_147009_r + 27 + y * 18, 16, 200, 16, 16);
            }
            if (++x <= 4) continue;
            x = 0;
            ++y;
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int x = 0;
        int y = 0;
        for (MachineBulbItem bulb : ModItems.MACHINEBULBS) {
            Block machine = bulb.getMachine();
            if (machine != null) {
                this.renderItem(new ItemStack((IItemProvider)machine), 59 + x * 18, 27 + y * 18);
            }
            if (++x <= 4) continue;
            x = 0;
            ++y;
        }
    }

    private int getCookProgressScaled(int pixels) {
        int i = ((MachineBulbReprocessorContainer)this.field_147002_h).getValue(4);
        return i != 0 ? i * pixels / ((MachineBulbReprocessorTileEntity)this.te).ticksPerItem() : 0;
    }

    @Override
    protected void drawTooltips(int mouseX, int mouseY) {
        this.drawTooltip(((MachineBulbReprocessorContainer)this.field_147002_h).getValue(2) + "/" + ((MachineBulbReprocessorContainer)this.field_147002_h).getValue(3), mouseX, mouseY, 41, 28, 16, 55);
        int x = 0;
        int y = 0;
        for (MachineBulbItem bulb : ModItems.MACHINEBULBS) {
            Block machine = bulb.getMachine();
            if (machine != null) {
                this.drawTooltip(new ItemStack((IItemProvider)machine).getHighlightTip(machine.func_200291_n().func_150254_d()), mouseX, mouseY, 59 + x * 18, 27 + y * 18, 16, 16);
            }
            if (++x <= 4) continue;
            x = 0;
            ++y;
        }
        super.drawTooltips(mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int p_mouseClicked_5_) {
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 5; ++x) {
                if (!this.inItemStackArea(mouseX, mouseY, 59 + x * 18, 27 + y * 18) || x + y * 5 >= ModItems.MACHINEBULBS.size()) continue;
                PlantTech2PacketHandler.sendToServer(new ButtonPressMessage(this.te.func_174877_v().func_177958_n(), this.te.func_174877_v().func_177956_o(), this.te.func_174877_v().func_177952_p(), x + y * 5 + 1));
            }
        }
        return super.mouseClicked(mouseX, mouseY, p_mouseClicked_5_);
    }

    public void renderItem(ItemStack itemstack, int x, int y) {
        this.itemRenderer.func_180450_b(itemstack, x, y);
    }

    private boolean inArea(double mouseX, double mouseY, int posX, int posY, int width, int height) {
        return mouseX >= (double)(posX += this.field_147003_i) && mouseX <= (double)(posX + width) && mouseY >= (double)(posY += this.field_147009_r) && mouseY <= (double)(posY + height);
    }

    private boolean inItemStackArea(double mouseX, double mouseY, int posX, int posY) {
        return this.inArea(mouseX, mouseY, posX, posY, 16, 16);
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    @Override
    protected String getGuideEntryString() {
        return "machinebulb_reprocessor";
    }
}

