/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui.guide;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.gui.buttons.CustomButton;
import net.kaneka.planttech2.gui.guide.Guide;
import net.kaneka.planttech2.gui.guide.GuideEntry;
import net.kaneka.planttech2.gui.guide.GuideMenu;
import net.kaneka.planttech2.gui.guide.GuidePicture;
import net.kaneka.planttech2.gui.guide.GuideString;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuideScreen
extends Screen {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2:textures/gui/guide.png");
    protected int xSize = 441;
    protected int ySize = 258;
    protected int guiLeft;
    protected int guiTop;
    protected final List<Widget> buttons_mainmenu = Lists.newArrayList();
    protected final List<Widget> buttons_entry = Lists.newArrayList();
    protected final List<Widget> buttons_navigation = Lists.newArrayList();
    private Guide guide = new Guide();
    int mode = 0;
    int menuid = 0;
    int entryid = 0;
    int page = 0;
    int maxPages = 0;
    int linesPerPage = 19;
    private List<GuideString> lines = new ArrayList<GuideString>();
    private List<GuidePicture> pics;

    public GuideScreen() {
        super((ITextComponent)new TranslationTextComponent("planttech2.guide", new Object[0]));
    }

    public GuideScreen(int menuid, int entryid) {
        this();
        this.mode = 2;
        this.menuid = menuid;
        this.entryid = entryid;
    }

    public void init() {
        int y;
        int x;
        super.init();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 5; ++y) {
                this.addButtonList(this.buttons_mainmenu, 1, x * 5 + y, this.guiLeft + 50 + x * 200, this.guiTop + 35 + y * 37, 150, 35, this.translateUnformated("guide.planttech2.amenu"));
            }
        }
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 5; ++y) {
                this.addButtonList(this.buttons_entry, 2, x * 5 + y, this.guiLeft + 50 + x * 200, this.guiTop + 35 + y * 37, 150, 20, this.translateUnformated("guide.planttech2.submenu"));
            }
        }
        this.addButtonList(this.buttons_navigation, 0, 0, this.guiLeft + 170, this.guiTop + 230, 100, 20, this.translateUnformated("gui.back"));
        this.addButtonList(this.buttons_navigation, 0, 1, this.guiLeft + 15, this.guiTop + 230, 100, 20, this.translateUnformated("gui.last"));
        this.addButtonList(this.buttons_navigation, 0, 2, this.guiLeft + 320, this.guiTop + 230, 100, 20, this.translateUnformated("gui.next"));
        this.deactivateButtonList(this.buttons_entry);
        this.deactivateButtonList(this.buttons_navigation);
        this.update(true);
    }

    protected void addButtonList(List<Widget> list, int buttontype, int id, int xPos, int yPos, int width, int height, String displayString) {
        CustomButton button = (CustomButton)this.addButton((Widget)new CustomButton(id, xPos, yPos, width, height, this.translateUnformated(displayString), btn -> this.buttonClicked(buttontype, id)));
        list.add((Widget)button);
    }

    protected void buttonClicked(int buttontype, int buttonid) {
        boolean modechange = false;
        if (buttontype == 0) {
            if (buttonid == 0) {
                if (this.mode >= 1) {
                    --this.mode;
                    this.page = 0;
                }
            } else if (buttonid == 1) {
                --this.page;
            } else if (buttonid == 2) {
                ++this.page;
            }
        } else {
            modechange = true;
            this.mode = buttontype;
            if (this.mode == 1) {
                this.menuid = buttonid;
            } else if (this.mode == 2) {
                this.entryid = buttonid + this.page * 10;
            }
        }
        this.update(modechange);
    }

    private void activateButton(Widget button) {
        button.active = true;
        button.visible = true;
    }

    private void deactivateButton(Widget button) {
        button.active = false;
        button.visible = false;
    }

    private void activateButtonList(List<Widget> list) {
        for (Widget button : list) {
            this.activateButton(button);
        }
    }

    private void deactivateButtonList(List<Widget> list) {
        for (Widget button : list) {
            this.deactivateButton(button);
        }
    }

    private void update(boolean modechange) {
        this.deactivateButtonList(this.buttons);
        if (this.mode == 0) {
            for (int i = 0; i < this.buttons_mainmenu.size(); ++i) {
                Widget button = this.buttons_mainmenu.get(i);
                if (i >= this.guide.getAmountMainMenus()) continue;
                this.activateButton(button);
                button.setMessage(this.guide.getMenuById(i).getName());
            }
        } else if (this.mode == 1) {
            GuideMenu menu = this.guide.getMenuById(this.menuid);
            this.maxPages = menu.getAmountEntrys() / 8;
            for (int i = 0; i < this.buttons_entry.size(); ++i) {
                Widget button = this.buttons_entry.get(i);
                if (i + this.page * 10 >= menu.getAmountEntrys()) continue;
                this.activateButton(button);
                button.setMessage(menu.getEntryById(i + this.page * 10).getName());
            }
            this.activateButton(this.buttons_navigation.get(0));
            if (this.page > 0) {
                this.activateButton(this.buttons_navigation.get(1));
            }
            if (this.maxPages - 1 > this.page) {
                this.activateButton(this.buttons_navigation.get(2));
            }
        } else if (this.mode == 2) {
            this.activateButton(this.buttons_navigation.get(0));
            if (modechange) {
                this.loadEntry();
            }
            if (this.page > 0) {
                this.activateButton(this.buttons_navigation.get(1));
            }
            if (this.maxPages - 1 > this.page) {
                this.activateButton(this.buttons_navigation.get(2));
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
        this.drawBackground();
        this.drawForeground();
        this.drawButtons(mouseX, mouseY, partialTicks);
        this.drawStrings();
        this.drawTooltips(mouseX, mouseY);
    }

    private void drawButtons(int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            ((Widget)this.buttons.get(i)).render(mouseX, mouseY, partialTicks);
        }
    }

    protected void drawBackground() {
        GuideScreen.blit((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)512, (int)512);
    }

    protected void drawForeground() {
        if (this.mode == 2 && !this.pics.isEmpty() && this.page == 0) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (GuidePicture pic : this.pics) {
                this.minecraft.func_110434_K().func_110577_a(pic.getResloc());
                GuideScreen.blit((int)(this.guiLeft + pic.getXStart() + 25), (int)(this.guiTop + pic.getYStart() + 30), (float)0.0f, (float)0.0f, (int)pic.getWidth(), (int)pic.getHeight(), (int)pic.getWidth(), (int)pic.getHeight());
            }
        }
    }

    protected void drawStrings() {
        if (this.mode == 0) {
            this.drawCenteredString(this.translateUnformated("guide.planttech2.header"), this.guiLeft + this.xSize / 2, this.guiTop + 15);
        } else if (this.mode == 1) {
            this.drawCenteredString(this.guide.getMenuById(this.menuid).getName(), this.guiLeft + this.xSize / 2, this.guiTop + 15);
        } else if (this.mode == 2) {
            this.drawCenteredString(this.guide.getMenuById(this.menuid).getEntryById(this.entryid).getHeader().func_150254_d(), this.guiLeft + this.xSize / 2, this.guiTop + 15);
            for (int i = 0; i < this.lines.size(); ++i) {
                GuideString guideString = this.lines.get(i);
                if (this.page * 19 > guideString.getLine() || guideString.getLine() >= this.page * 19 + 19) continue;
                this.drawLine(guideString.getString(), this.guiLeft + 25 + guideString.getX(), this.guiTop + 30 + 10 * (guideString.getLine() - 19 * this.page));
            }
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
    }

    protected String translateUnformated(String name) {
        return new TranslationTextComponent(name, new Object[0]).func_150261_e();
    }

    protected void drawCenteredString(String string, int posX, int posY) {
        this.font.func_211126_b(string, (float)(posX - this.font.func_78256_a(string) / 2), (float)posY, Integer.parseInt("000000", 16));
    }

    protected void drawLine(String text, int x, int y) {
        this.font.func_211126_b(text, (float)x, (float)y, Integer.parseInt("000000", 16));
    }

    protected void loadEntry() {
        GuideEntry entry = this.guide.getMenuById(this.menuid).getEntryById(this.entryid);
        this.pics = entry.getPictures();
        this.lines = entry.getTextFormated(this.font);
        this.page = 0;
        this.maxPages = (int)Math.ceil((double)this.lines.size() / (double)this.linesPerPage);
    }
}

