/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.items.BaseItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class BiomassContainerItem
extends BaseItem {
    private static int CAPACITY = 1000;

    public BiomassContainerItem() {
        super("biomasscontainer", new Item.Properties().func_200916_a(ModCreativeTabs.groupmain).func_200917_a(1));
        this.func_185043_a(new ResourceLocation("filled"), (stack, world, player) -> BiomassContainerItem.getFillLevelModel(stack));
    }

    public static float getFillLevelModel(ItemStack stack) {
        int biomass = BiomassContainerItem.getCurrentStorage(stack);
        if (biomass > CAPACITY / 9 * 9) {
            return 9.0f;
        }
        if (biomass > CAPACITY / 9 * 8) {
            return 8.0f;
        }
        if (biomass > CAPACITY / 9 * 7) {
            return 7.0f;
        }
        if (biomass > CAPACITY / 9 * 6) {
            return 6.0f;
        }
        if (biomass > CAPACITY / 9 * 5) {
            return 5.0f;
        }
        if (biomass > CAPACITY / 9 * 4) {
            return 4.0f;
        }
        if (biomass > CAPACITY / 9 * 3) {
            return 3.0f;
        }
        if (biomass > CAPACITY / 9 * 2) {
            return 2.0f;
        }
        if (biomass > CAPACITY / 9 * 1) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static int extractBiomass(ItemStack stack, int amount) {
        int current = BiomassContainerItem.getCurrentStorage(stack);
        if (current < amount) {
            BiomassContainerItem.changeCurrentStorage(stack, -current);
            return current;
        }
        BiomassContainerItem.changeCurrentStorage(stack, -amount);
        return amount;
    }

    public static int receiveBiomass(ItemStack stack, int amount) {
        int current = BiomassContainerItem.getCurrentStorage(stack);
        if (current + amount > CAPACITY) {
            BiomassContainerItem.changeCurrentStorage(stack, CAPACITY - current);
            return -CAPACITY + current;
        }
        BiomassContainerItem.changeCurrentStorage(stack, amount);
        return -amount;
    }

    public static void changeCurrentStorage(ItemStack stack, int amount) {
        int current = BiomassContainerItem.getCurrentStorage(stack);
        current = current + amount < 0 ? 0 : (current + amount > CAPACITY ? CAPACITY : (current += amount));
        BiomassContainerItem.setCurrentStorage(stack, current);
    }

    public static void setCurrentStorage(ItemStack stack, int value) {
        BiomassContainerItem.initTag(stack).func_74768_a("biomass", value < 0 ? 0 : Math.min(value, CAPACITY));
    }

    public static int getCurrentStorage(ItemStack stack) {
        return BiomassContainerItem.initTag(stack).func_74762_e("biomass");
    }

    public static int getCapacity() {
        return CAPACITY;
    }

    private static CompoundNBT initTag(ItemStack stack) {
        CompoundNBT compoundNBT;
        if (stack.func_77942_o()) {
            compoundNBT = stack.func_77978_p();
        } else {
            compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("biomass", 0);
            stack.func_77982_d(compoundNBT);
        }
        return compoundNBT;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(BiomassContainerItem.getCurrentStorage(stack) + "/" + BiomassContainerItem.getCapacity()));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == this.field_77701_a) {
            items.add((Object)new ItemStack((IItemProvider)ModItems.BIOMASSCONTAINER));
            ItemStack full = new ItemStack((IItemProvider)ModItems.BIOMASSCONTAINER);
            BiomassContainerItem.setCurrentStorage(full, BiomassContainerItem.getCapacity());
            items.add((Object)full);
        }
    }
}

