/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.items.BaseItem;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CropSeedItem
extends BaseItem {
    private String entryName;
    private int TRAIT_MIN = 0;
    private int TRAIT_MAX = 1;

    public CropSeedItem(String entryName) {
        super(entryName + "_seeds", new Item.Properties().func_200916_a(ModCreativeTabs.groupseeds));
        this.entryName = entryName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            if (nbt.func_74767_n("analysed")) {
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.type", new Object[0]).func_150261_e() + ": " + nbt.func_74779_i("type")));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.soil", new Object[0]).func_150261_e() + ": " + CropSeedItem.getSoilString(nbt.func_74779_i("type"))));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.temperature", new Object[0]).func_150261_e() + ": " + CropSeedItem.temperatureString(nbt.func_74779_i("type"), nbt.func_74762_e("temperaturetolerance"))));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "growspeed") + new TranslationTextComponent("info.growspeed", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("growspeed")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "sensitivity") + new TranslationTextComponent("info.sensitivity", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("sensitivity")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "lightsensitivity") + new TranslationTextComponent("info.needed_lightlevel", new Object[0]).func_150261_e() + ": " + (14 - nbt.func_74762_e("lightsensitivity"))));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "watersensitivity") + new TranslationTextComponent("info.waterrange", new Object[0]).func_150261_e() + ": " + (1 + nbt.func_74762_e("watersensitivity"))));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "productivity") + new TranslationTextComponent("info.productivity", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("productivity")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "fertility") + new TranslationTextComponent("info.fertility", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("fertility")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "spreedingspeed") + new TranslationTextComponent("info.spreedingspeed", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("spreedingspeed")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "genestrenght") + new TranslationTextComponent("info.genestrength", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("genestrenght")));
                tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(nbt, "energyvalue") + new TranslationTextComponent("info.energyvalue", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("energyvalue") * 20));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.type", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.soil", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.temperaturetolerance", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.growspeed", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.sensitivity", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.needed_lightlevel", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.waterrange", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.productivity", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.fertility", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.spreedingspeed", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.genestrength", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.energyvalue", new Object[0]).func_150261_e() + ": " + new TranslationTextComponent("info.unknown", new Object[0]).func_150261_e()));
            }
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.type", new Object[0]).func_150261_e() + ": " + this.entryName));
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.soil", new Object[0]).func_150261_e() + ": " + CropSeedItem.getSoilString(this.entryName)));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.growspeed", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.sensitivity", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.needed_lightlevel", new Object[0]).func_150261_e() + ": " + 14));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.waterrange", new Object[0]).func_150261_e() + ": " + 1));
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.temperaturetolerance", new Object[0]).func_150261_e() + ": " + CropSeedItem.temperatureString(this.entryName, 0)));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.productivity", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.fertility", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.spreedingspeed", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.genestrength", new Object[0]).func_150261_e() + ": " + 0));
            tooltip.add((ITextComponent)new StringTextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslationTextComponent("info.energyvalue", new Object[0]).func_150261_e() + ": " + 20));
        }
    }

    public static String temperatureString(String type, int tolerance) {
        if (tolerance == 0) {
            return PlantTechMain.croplist.getEntryByName(type).getTemperature().getDisplayString(true);
        }
        int id = PlantTechMain.croplist.getEntryByName(type).getTemperature().getId();
        int min = id - tolerance;
        int max = id + tolerance;
        if (min < 0) {
            min = 0;
        }
        if (max > 4) {
            max = 4;
        }
        return EnumTemperature.byId(min).getDisplayString(true) + " - " + EnumTemperature.byId(max).getDisplayString(true);
    }

    public static String getSoilString(String type) {
        ItemStack soil = PlantTechMain.croplist.getEntryByName(type).getSoil();
        if (soil.func_190926_b()) {
            return " / ";
        }
        return soil.func_200301_q().func_150261_e();
    }

    private TextFormatting getTraitColor(CompoundNBT nbt, String trait) {
        if (nbt.func_74762_e(trait) == Objects.requireNonNull(EnumTraitsInt.getByName(trait)).getMax()) {
            return this.getTraitColor(this.TRAIT_MAX);
        }
        if (nbt.func_74762_e(trait) == Objects.requireNonNull(EnumTraitsInt.getByName(trait)).getMin()) {
            return this.getTraitColor(this.TRAIT_MIN);
        }
        return TextFormatting.RESET;
    }

    private TextFormatting getTraitColor(int level) {
        if (level == this.TRAIT_MIN) {
            return TextFormatting.GRAY;
        }
        if (level == this.TRAIT_MAX) {
            return TextFormatting.GREEN;
        }
        return TextFormatting.RESET;
    }

    public static class ColorHandler
    implements IItemColor {
        public int getColor(ItemStack stack, int color) {
            return PlantTechMain.croplist.getEntryByName(((CropSeedItem)stack.func_77973_b()).getEntryName()).getSeedColor();
        }
    }
}

