/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.items.BaseItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class KnowledgeChip
extends BaseItem {
    private int tier;
    private int maxKnowledge;

    public KnowledgeChip(int tier, int maxKnowledge) {
        super("knowledgechip_" + String.valueOf(tier), new Item.Properties().func_200917_a(1).func_200916_a(ModCreativeTabs.groupmain));
        this.tier = tier;
        this.maxKnowledge = maxKnowledge;
    }

    public int getTier() {
        return this.tier;
    }

    public int getMaxKnowledge() {
        return this.maxKnowledge;
    }

    public static int getMaxTier() {
        return 5;
    }

    public static ItemStack addKnowledge(ItemStack stack, int amount, int maxTier) {
        KnowledgeChip chip;
        Item item;
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof KnowledgeChip && (chip = (KnowledgeChip)item).getTier() <= maxTier) {
            CompoundNBT nbt = stack.func_196082_o();
            int newknowledge = 0;
            newknowledge = nbt.func_74764_b("knowledge") ? nbt.func_74762_e("knowledge") + amount : amount;
            if (newknowledge < chip.getMaxKnowledge()) {
                nbt.func_74768_a("knowledge", newknowledge);
                stack.func_77982_d(nbt);
            } else {
                ItemStack nextChip = KnowledgeChip.getByTier(chip.tier + 1);
                if (!nextChip.func_190926_b()) {
                    return nextChip;
                }
                nbt.func_74768_a("knowledge", chip.getMaxKnowledge());
                stack.func_77982_d(nbt);
            }
        }
        return stack;
    }

    public static ItemStack getByTier(int tier) {
        switch (tier) {
            case 0: {
                return new ItemStack((IItemProvider)ModItems.KNOWLEDGECHIP_TIER_0);
            }
            case 1: {
                return new ItemStack((IItemProvider)ModItems.KNOWLEDGECHIP_TIER_1);
            }
            case 2: {
                return new ItemStack((IItemProvider)ModItems.KNOWLEDGECHIP_TIER_2);
            }
            case 3: {
                return new ItemStack((IItemProvider)ModItems.KNOWLEDGECHIP_TIER_3);
            }
            case 4: {
                return new ItemStack((IItemProvider)ModItems.KNOWLEDGECHIP_TIER_4);
            }
            case 5: {
                return new ItemStack((IItemProvider)ModItems.KNOWLEDGECHIP_TIER_5);
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("knowledge")) {
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.knowledge", new Object[0]).func_150261_e() + ": " + nbt.func_74762_e("knowledge") + "/" + this.getMaxKnowledge()));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.knowledge", new Object[0]).func_150261_e() + ": 0/" + this.getMaxKnowledge()));
        }
    }
}

