/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.baseclasses.NaturalPlants;
import net.kaneka.planttech2.blocks.interfaces.IObtainable;
import net.kaneka.planttech2.items.BaseItem;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class PlantObtainer
extends BaseItem {
    public PlantObtainer(String name, Item.Properties property) {
        super(name, property.func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        IObtainable block;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = player.func_184614_ca();
        PlantObtainer.initTags(stack);
        if (state.func_177230_c() instanceof IObtainable) {
            IObtainable block2 = (IObtainable)state.func_177230_c();
            if (!PlantObtainer.isFilled(stack) && block2.isObtainable(context)) {
                PlantObtainer.setBlockFilled(stack, state);
                block2.onObtained(world, player, stack, pos);
                world.func_184133_a(player, pos, SoundEvents.field_187812_eh, SoundCategory.BLOCKS, 0.15f, 10.0f);
                return ActionResultType.SUCCESS;
            }
        } else if (PlantObtainer.isFilled(stack) && ((NaturalPlants)((Object)(block = (IObtainable)PlantObtainer.getBlockStateFilled(stack).func_177230_c()))).canPlaceAt(world, pos.func_177972_a(context.func_196000_l()))) {
            block.onReleased(context, PlantObtainer.getBlockStateFilled(stack));
            PlantObtainer.setBlockFilled(stack, null);
            PlantObtainer.setFilled(stack, false);
            world.func_184133_a(player, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 10.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_77636_d(ItemStack stack) {
        return PlantObtainer.isFilled(PlantObtainer.initTags(stack));
    }

    public static ItemStack setBlockFilled(ItemStack stack, BlockState state) {
        CompoundNBT compound;
        CompoundNBT compoundNBT = compound = stack.func_77942_o() ? stack.func_77978_p() : PlantObtainer.initTags(stack).func_77978_p();
        if (state == Blocks.field_150350_a.func_176223_P() || state != null) {
            compound.func_197643_a(NBTUtil.func_190009_a((BlockState)state));
            PlantObtainer.setFilled(stack, true);
        } else {
            NBTUtil.func_190009_a((BlockState)Blocks.field_150350_a.func_176223_P());
            PlantObtainer.setFilled(stack, false);
        }
        stack.func_77982_d(compound);
        return stack;
    }

    public static BlockState getBlockStateFilled(ItemStack stack) {
        CompoundNBT compound = stack.func_77942_o() ? stack.func_77978_p() : PlantObtainer.initTags(stack).func_77978_p();
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)compound);
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return null;
        }
        PlantObtainer.setFilled(stack, true);
        return state;
    }

    public static ItemStack setFilled(ItemStack stack, boolean filled) {
        CompoundNBT compound;
        CompoundNBT compoundNBT = compound = stack.func_77942_o() ? stack.func_77978_p() : PlantObtainer.initTags(stack).func_77978_p();
        if (!filled) {
            compound.func_197643_a(NBTUtil.func_190009_a((BlockState)Blocks.field_150350_a.func_176223_P()));
        }
        compound.func_74757_a("filled", filled);
        stack.func_77982_d(compound);
        return stack;
    }

    public static boolean isFilled(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("filled") && PlantObtainer.getBlockStateFilled(stack) != null;
    }

    public static ItemStack initTags(ItemStack stack) {
        CompoundNBT compound = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        stack.func_77982_d(compound);
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("Right click on an unique plants found planttopia to obtain and store it in the void"));
        tooltip.add((ITextComponent)new StringTextComponent("Right click again to get it back"));
        PlantObtainer.initTags(stack);
        if (PlantObtainer.isFilled(stack)) {
            tooltip.add((ITextComponent)new StringTextComponent("Plant Obtained: " + PlantObtainer.getBlockStateFilled(stack).func_177230_c().func_200291_n().func_150255_a(new Style().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true))).func_150254_d()));
        } else {
            tooltip.add(new StringTextComponent("Empty").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true))));
        }
    }
}

