/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.recipes.recipeclasses;

import com.google.gson.JsonObject;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.utilities.TagUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CompressorRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private final ItemStack input;
    private final ItemStack output;

    public CompressorRecipe(ResourceLocation id, ItemStack input, ItemStack output) {
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.input.func_77973_b() == inv.func_70301_a(0).func_77973_b();
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output.func_77946_l();
    }

    public ItemStack getInput() {
        return this.input;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public int getAmountInput() {
        return this.input.func_190916_E();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation("planttech2", "compressing"));
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipeTypes.COMPRESSING;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CompressorRecipe> {
        public CompressorRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputobject = json.getAsJsonObject("input");
            Item inputitem = null;
            Potion effect = null;
            Enchantment enchantType = null;
            int enchantLevel = 0;
            if (inputobject.has("item")) {
                inputitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("item").getAsString()));
            } else if (inputobject.has("block")) {
                inputitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("block").getAsString()));
            } else if (inputobject.has("tag")) {
                inputitem = TagUtils.getAnyTagItem(new ResourceLocation(inputobject.get("tag").getAsString()));
            }
            ItemStack inputstack = null;
            if (inputitem != null) {
                inputstack = new ItemStack((IItemProvider)inputitem, JSONUtils.func_151208_a((JsonObject)inputobject, (String)"amount", (int)1));
            }
            JsonObject resultobject = json.getAsJsonObject("result");
            Item resultitem = null;
            if (resultobject.has("item")) {
                resultitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("item").getAsString()));
                if (resultobject.has("potion_effect")) {
                    effect = (Potion)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation(resultobject.get("potion_effect").getAsString()));
                }
                if (resultobject.has("enchantment")) {
                    JsonObject enchantment = resultobject.getAsJsonObject("enchantment");
                    enchantType = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantment.get("type").getAsString()));
                    enchantLevel = JSONUtils.func_151208_a((JsonObject)enchantment, (String)"level", (int)1);
                }
            } else if (resultobject.has("block")) {
                resultitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("block").getAsString()));
            } else if (resultobject.has("tag")) {
                resultitem = TagUtils.getAnyTagItem(new ResourceLocation(resultobject.get("tag").getAsString()));
            }
            ItemStack resultstack = null;
            if (resultitem != null) {
                resultstack = new ItemStack((IItemProvider)resultitem, JSONUtils.func_151208_a((JsonObject)resultobject, (String)"amount", (int)1));
                if (effect != null) {
                    PotionUtils.func_185188_a((ItemStack)resultstack, (Potion)effect);
                } else if (enchantType != null) {
                    resultstack.func_77966_a(enchantType, enchantLevel);
                }
            }
            if (inputstack != null && resultstack != null) {
                return new CompressorRecipe(recipeId, inputstack, resultstack);
            }
            throw new IllegalStateException("Item did not exist:" + recipeId.toString());
        }

        public CompressorRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ItemStack input = buffer.func_150791_c();
            ItemStack result = buffer.func_150791_c();
            return new CompressorRecipe(recipeId, input, result);
        }

        public void write(PacketBuffer buffer, CompressorRecipe recipe) {
            buffer.func_150788_a(recipe.input);
            buffer.func_150788_a(recipe.output);
        }
    }
}

