/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.kaneka.planttech2.container.ChipalyzerContainer;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.ChipalyzerRecipe;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IIntArray;

public class ChipalyzerTileEntity
extends EnergyInventoryTileEntity {
    private int ticksPassed = 0;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return ChipalyzerTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return ChipalyzerTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return ChipalyzerTileEntity.this.ticksPassed;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    ChipalyzerTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    ChipalyzerTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    ChipalyzerTileEntity.this.ticksPassed = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public ChipalyzerTileEntity() {
        super(ModTileEntities.CHIPALYZER_TE, 1000, 7, 2);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() > this.energyPerTick()) {
            List<ChipalyzerRecipe> recipe;
            ItemStack stackChip = this.itemhandler.getStackInSlot(0);
            ItemStack stackInput = this.itemhandler.getStackInSlot(1);
            ItemStack stackOutput = this.itemhandler.getStackInSlot(2);
            if (!(stackChip.func_190926_b() || stackInput.func_190926_b() || (recipe = this.getRecipeList(stackChip, stackInput)).isEmpty())) {
                if (this.ticksPassed < this.ticksPerItem()) {
                    ++this.ticksPassed;
                    this.energystorage.extractEnergy(this.energyPerTick(), false);
                } else if (stackOutput.func_190926_b()) {
                    ItemStack result = recipe.get(new Random().nextInt(recipe.size())).func_77571_b().func_77946_l();
                    this.itemhandler.setStackInSlot(2, result);
                    this.energystorage.extractEnergy(this.energyPerTick(), false);
                    stackChip.func_190918_g(1);
                    stackInput.func_190918_g(1);
                    this.addKnowledge();
                    this.ticksPassed = 0;
                }
            }
        }
        this.doEnergyLoop();
    }

    private List<ChipalyzerRecipe> getRecipeList(ItemStack chip, ItemStack stack) {
        ArrayList<ChipalyzerRecipe> list = new ArrayList<ChipalyzerRecipe>();
        if (!stack.func_190926_b() && this.field_145850_b != null) {
            for (IRecipe recipe : this.field_145850_b.func_199532_z().func_199510_b()) {
                ChipalyzerRecipe chipRecipe;
                if (recipe.func_222127_g() != ModRecipeTypes.CHIPALYZER || !ItemStack.func_77989_b((ItemStack)(chipRecipe = (ChipalyzerRecipe)recipe).getChip(), (ItemStack)chip) || !chipRecipe.compare(chip, stack)) continue;
                list.add(chipRecipe);
            }
        }
        return list;
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(3, 2) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(3, 2) * 35;
    }

    @Override
    public String getNameString() {
        return "chipalyzer";
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("tickspassed", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.ticksPassed = compound.func_74762_e("tickspassed");
        super.func_145839_a(compound);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ChipalyzerContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 4;
    }

    @Override
    public int getEnergyOutSlot() {
        return 5;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 6;
    }

    @Override
    public int getKnowledgePerAction() {
        return 100;
    }
}

