/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.Collection;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.container.PlantFarmContainer;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryFluidTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class PlantFarmTileEntity
extends EnergyInventoryFluidTileEntity {
    private int[] progress = new int[5];
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return PlantFarmTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return PlantFarmTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return PlantFarmTileEntity.this.BIOMASS_CAP.getCurrentStorage();
                }
                case 3: {
                    return PlantFarmTileEntity.this.BIOMASS_CAP.getMaxStorage();
                }
                case 4: {
                    return PlantFarmTileEntity.this.progress[0];
                }
                case 5: {
                    return PlantFarmTileEntity.this.progress[1];
                }
                case 6: {
                    return PlantFarmTileEntity.this.progress[2];
                }
                case 7: {
                    return PlantFarmTileEntity.this.progress[3];
                }
                case 8: {
                    return PlantFarmTileEntity.this.progress[4];
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    PlantFarmTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    PlantFarmTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    PlantFarmTileEntity.this.BIOMASS_CAP.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    PlantFarmTileEntity.this.BIOMASS_CAP.setMaxStorage(value);
                    break;
                }
                case 4: {
                    ((PlantFarmTileEntity)PlantFarmTileEntity.this).progress[0] = value;
                    break;
                }
                case 5: {
                    ((PlantFarmTileEntity)PlantFarmTileEntity.this).progress[1] = value;
                    break;
                }
                case 6: {
                    ((PlantFarmTileEntity)PlantFarmTileEntity.this).progress[2] = value;
                    break;
                }
                case 7: {
                    ((PlantFarmTileEntity)PlantFarmTileEntity.this).progress[3] = value;
                    break;
                }
                case 8: {
                    ((PlantFarmTileEntity)PlantFarmTileEntity.this).progress[4] = value;
                }
            }
        }

        public int func_221478_a() {
            return 9;
        }
    };

    public PlantFarmTileEntity() {
        super(ModTileEntities.PLANTFARM_TE, 1000, 18, 5000, 5);
    }

    @Override
    public void doUpdate() {
        int range = this.getRange();
        ItemStack seed = this.itemhandler.getStackInSlot(0);
        if (!seed.func_190926_b() && this.isSeed(seed)) {
            for (int i = 0; i <= range; ++i) {
                NonNullList<ItemStack> drops;
                if (this.progress[i] < this.getTicks(seed)) {
                    int n = i;
                    this.progress[n] = this.progress[n] + 1;
                    continue;
                }
                if (this.energystorage.getEnergyStored() <= this.getEnergyPerAction() || (drops = this.getDrops(seed)).isEmpty()) continue;
                for (ItemStack stack : drops) {
                    for (int k = 0; k < 15; ++k) {
                        if (stack.func_190926_b()) continue;
                        stack = this.itemhandler.insertItem(k, stack, false);
                    }
                    if (stack.func_190926_b()) continue;
                    PlantFarmTileEntity.spawnAsEntity(this.field_145850_b, this.field_174879_c.func_177984_a(), stack);
                }
                this.energystorage.extractEnergy(this.getEnergyPerAction(), false);
                this.progress[i] = 0;
                this.addKnowledge();
            }
        }
        this.doEnergyLoop();
        this.doFluidLoop();
    }

    private boolean isSeed(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Block block;
            Item item = stack.func_77973_b();
            if (item instanceof CropSeedItem) {
                return true;
            }
            if (item instanceof BlockItem && (block = ((BlockItem)item).func_179223_d()) instanceof CropsBlock) {
                return true;
            }
        }
        return false;
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    private int getTicks(ItemStack stack) {
        CompoundNBT nbt;
        Item item;
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof CropSeedItem && stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("growspeed")) {
            return (90 - nbt.func_74762_e("growspeed") * 6) * 20 * 7;
        }
        return 12600;
    }

    public int getTicks() {
        CompoundNBT nbt;
        Item item;
        ItemStack stack = this.itemhandler.getStackInSlot(0);
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof CropSeedItem && (nbt = stack.func_77978_p()).func_74764_b("growspeed")) {
            return (90 - nbt.func_74762_e("growspeed") * 6) * 20 * 7;
        }
        return 12600;
    }

    private int getEnergyPerAction() {
        return 400;
    }

    private NonNullList<ItemStack> getDrops(ItemStack stack) {
        NonNullList drops = NonNullList.func_191196_a();
        if (!stack.func_190926_b()) {
            Block block;
            Item item = stack.func_77973_b();
            if (item instanceof CropSeedItem) {
                HashMapCropTraits traits = new HashMapCropTraits();
                traits.fromStack(stack);
                PlantTechMain.croplist.getEntryByName(traits.getType()).calculateDropsReduced((NonNullList<ItemStack>)drops, traits, 7);
                return drops;
            }
            if (item instanceof BlockItem && (block = ((BlockItem)item).func_179223_d()) != null && block instanceof CropsBlock && this.field_145850_b instanceof ServerWorld) {
                drops.addAll((Collection)Block.func_220070_a((BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)CropsBlock.field_176488_a, (Comparable)Integer.valueOf(7))), (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)this.field_174879_c, null));
            }
        }
        return drops;
    }

    private int getRange() {
        TierItem item;
        ItemStack stack = this.itemhandler.getStackInSlot(12);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof TierItem && (item = (TierItem)stack.func_77973_b()).getItemType() == 1) {
            return item.getTier();
        }
        return 0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        for (int i = 0; i < this.progress.length; ++i) {
            compound.func_74768_a("progress_" + i, this.progress[i]);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        for (int i = 0; i < this.progress.length; ++i) {
            this.progress[i] = compound.func_74762_e("progress_" + i);
        }
        super.func_145839_a(compound);
    }

    @Override
    public String getNameString() {
        return "plantfarm";
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new PlantFarmContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 15;
    }

    @Override
    public int getEnergyOutSlot() {
        return 16;
    }

    @Override
    public int getFluidInSlot() {
        return 13;
    }

    @Override
    public int getFluidOutSlot() {
        return 14;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 17;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }
}

