/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.container.SolarGeneratorContainer;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IIntArray;

public class SolarGeneratorTileEntity
extends EnergyInventoryTileEntity {
    int workload = 0;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return SolarGeneratorTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return SolarGeneratorTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return SolarGeneratorTileEntity.this.workload;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    SolarGeneratorTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    SolarGeneratorTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    SolarGeneratorTileEntity.this.workload = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public SolarGeneratorTileEntity() {
        super(ModTileEntities.SOLARGENERATOR_TE, 10000, 5, 5);
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.func_72935_r() && this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.energystorage.getMaxEnergyStored() - this.energystorage.getEnergyStored() > 0) {
            ++this.workload;
            if (this.workload >= this.getTicksPerAmount()) {
                this.energystorage.receiveEnergy(this.getEnergyPerTick(this.getUpgradeTier(0, 0)));
                this.workload = 0;
                this.addKnowledge();
            }
        }
        this.doEnergyLoop();
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    private int getEnergyPerTick(int focusLevel) {
        switch (focusLevel) {
            case 1: {
                return 20;
            }
            case 2: {
                return 60;
            }
            case 3: {
                return 180;
            }
            case 4: {
                return 540;
            }
        }
        return 0;
    }

    public int getTicksPerAmount() {
        return 80 - this.getUpgradeTier(1, 2) * 15;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("workload", this.workload);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.workload = compound.func_74762_e("workload");
        super.func_145839_a(compound);
    }

    @Override
    public String getNameString() {
        return "solargenerator";
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new SolarGeneratorContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 2;
    }

    @Override
    public int getEnergyOutSlot() {
        return 3;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 4;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }
}

