/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2;

import net.kaneka.planttech2.configuration.PlantTech2Configuration;
import net.kaneka.planttech2.datapack.reloadlistener.ReloadListenerCropListEntryConfiguration;
import net.kaneka.planttech2.entities.neutral.TechGhoulEntity;
import net.kaneka.planttech2.events.AttachCapabilityEvents;
import net.kaneka.planttech2.events.ClientEvents;
import net.kaneka.planttech2.events.PlayerEvents;
import net.kaneka.planttech2.handlers.CapabilityHandler;
import net.kaneka.planttech2.handlers.LootTableHandler;
import net.kaneka.planttech2.items.BiomassContainerItem;
import net.kaneka.planttech2.items.PlantObtainerItem;
import net.kaneka.planttech2.items.upgradeable.MultitoolItem;
import net.kaneka.planttech2.items.upgradeable.RangedWeaponItem;
import net.kaneka.planttech2.librarys.CropList;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.kaneka.planttech2.proxy.ClientProxy;
import net.kaneka.planttech2.proxy.IProxy;
import net.kaneka.planttech2.proxy.ServerProxy;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModEntityTypes;
import net.kaneka.planttech2.registries.ModFluids;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModRenderer;
import net.kaneka.planttech2.registries.ModScreens;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="planttech2")
public class PlantTechMain {
    public static final String MODID = "planttech2";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static final Logger LOGGER = LogManager.getLogger((String)"planttech2");
    public static PlantTechMain instance;
    public static CropList croplist;

    public PlantTechMain() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, PlantTech2Configuration.SERVER, "planttech2-server.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, PlantTech2Configuration.CLIENT, "planttech2-client.toml");
        PlantTech2Configuration.loadConfig(PlantTech2Configuration.CLIENT, FMLPaths.CONFIGDIR.get().resolve("planttech2-client.toml").toString());
        PlantTech2Configuration.loadConfig(PlantTech2Configuration.SERVER, FMLPaths.CONFIGDIR.get().resolve("planttech2-server.toml").toString());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEvents::registerColorBlock);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEvents::registerColorItem);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEvents::onWorldStart);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEvents::onFogRenderDensity);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEvents::onFogRenderColour);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(PlayerEvents::playerConnect);
        MinecraftForge.EVENT_BUS.addListener(AttachCapabilityEvents::attachEntityCapability);
        MinecraftForge.EVENT_BUS.addListener(AttachCapabilityEvents::attachTileEntityCapability);
        MinecraftForge.EVENT_BUS.addListener(PlayerEvents::playerTicking);
        MinecraftForge.EVENT_BUS.addListener(PlayerEvents::onPlayerClone);
        MinecraftForge.EVENT_BUS.addListener(PlayerEvents::onPlayerChangedDimension);
        MinecraftForge.EVENT_BUS.addListener(PlayerEvents::onPlayerRespawn);
        MinecraftForge.EVENT_BUS.addListener(PlayerEvents::onPlayerHurt);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListener);
    }

    private void onServerAboutToStarting(FMLServerAboutToStartEvent event) {
    }

    private void addReloadListener(AddReloadListenerEvent event) {
        DeferredWorkQueue.runLater(() -> event.addListener((IFutureReloadListener)new ReloadListenerCropListEntryConfiguration()));
    }

    private void onServerStarting(FMLServerStartingEvent event) {
    }

    private void setup(FMLCommonSetupEvent event) {
        new ModRecipeTypes();
        CapabilityHandler.registerAll();
        PlantTech2PacketHandler.register();
        croplist.configurePlanttechEntries();
        LootTableHandler.register();
        DeferredWorkQueue.runLater(PlantTechMain::registerAllEntityAttributes);
    }

    private static void registerAllEntityAttributes() {
        GlobalEntityTypeAttributes.put(ModEntityTypes.TECHGHOULENTITY, (AttributeModifierMap)TechGhoulEntity.getAttributes().func_233813_a_());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ModRenderer.registerEntityRenderer();
        ModScreens.registerGUI();
        for (Block block : ModBlocks.SPECIAL_RENDER_BLOCKS) {
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_());
        }
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.BIOMASSFLUIDBLOCK, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)ModFluids.BIOMASS, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)ModFluids.BIOMASS_FLOWING, (RenderType)RenderType.func_228645_f_());
        DeferredWorkQueue.runLater(PlantTechMain::addAllItemModelsOverrides);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addAllItemModelsOverrides() {
        ItemModelsProperties.func_239418_a_((Item)ModItems.MULTITOOL, (ResourceLocation)new ResourceLocation(MODID, "drilling"), (stack, world, entity) -> entity == null || !(stack.func_77973_b() instanceof MultitoolItem) ? 0.0f : (float)(entity.field_70173_aa % 4 + 1));
        ItemModelsProperties.func_239418_a_((Item)ModItems.PLANT_OBTAINER, (ResourceLocation)new ResourceLocation(MODID, "filled"), (stack, world, entity) -> {
            if (!(stack.func_77973_b() instanceof PlantObtainerItem)) {
                return 0.0f;
            }
            return PlantObtainerItem.isFilled(PlantObtainerItem.initTags(stack)) ? 1.0f : 0.0f;
        });
        ItemModelsProperties.func_239418_a_((Item)ModItems.PLANT_OBTAINER, (ResourceLocation)new ResourceLocation(MODID, "filled"), (stack, world, entity) -> BiomassContainerItem.getFillLevelModel(stack));
        ItemModelsProperties.func_239418_a_((Item)ModItems.CYBERBOW, (ResourceLocation)new ResourceLocation(MODID, "pull"), (stack, world, entity) -> entity == null || !(entity.func_184607_cu().func_77973_b() instanceof RangedWeaponItem) ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f);
        ItemModelsProperties.func_239418_a_((Item)ModItems.CYBERBOW, (ResourceLocation)new ResourceLocation(MODID, "pulling"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
    }

    static {
        croplist = new CropList();
    }
}

