/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.kaneka.planttech2.blocks.baseclasses.BaseBlock;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class GrowingBlock
extends BaseBlock {
    public static final IntegerProperty GROWINGSTATE = IntegerProperty.func_177719_a((String)"growingstate", (int)0, (int)6);
    protected final Block block;
    protected boolean growAlone;

    public GrowingBlock(String name, Block block, boolean growAlone) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(0.9f).func_200944_c(), name, ModCreativeTabs.groupmain, false, true);
        this.block = block;
        this.growAlone = growAlone;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)GROWINGSTATE, (Comparable)Integer.valueOf(0)));
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        if (this.growAlone) {
            this.grow(state, world, pos);
        }
    }

    public void grow(BlockState state, ServerWorld world, BlockPos pos) {
        int i = (Integer)state.func_177229_b((Property)GROWINGSTATE);
        if (i < 6) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)GROWINGSTATE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
        if (i >= 6) {
            this.placeBlock(world, pos, state);
        }
    }

    protected void placeBlock(ServerWorld world, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, this.block.func_176223_P());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{GROWINGSTATE});
    }

    public Block getBlock() {
        return this.block;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList drops = Lists.newArrayList();
        Block block = state.func_177230_c();
        if (block == ModBlocks.COMPRESSOR_GROWING || block == ModBlocks.MACHINEBULBREPROCESSOR_GROWING || block == ModBlocks.SEEDSQUEEZER_GROWING || block == ModBlocks.INFUSER_GROWING || block == ModBlocks.IDENTIFIER_GROWING) {
            drops.add(new ItemStack((IItemProvider)ModBlocks.MACHINESHELL_IRON));
        } else if (block == ModBlocks.MACHINESHELL_IRON_GROWING) {
            drops.add(new ItemStack((IItemProvider)Blocks.field_150339_S));
        } else if (block == ModBlocks.MACHINESHELL_PLANTIUM_GROWING) {
            drops.add(new ItemStack((IItemProvider)ModBlocks.PLANTIUM_BLOCK));
        } else {
            drops.add(new ItemStack((IItemProvider)ModBlocks.MACHINESHELL_PLANTIUM));
        }
        return drops;
    }
}

