/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.baseclasses;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.baseclasses.BaseBlock;
import net.kaneka.planttech2.blocks.machines.EnergySupplierBlock;
import net.kaneka.planttech2.registries.ModSounds;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BaseElectricFence
extends BaseBlock {
    public static final IntegerProperty ELECTRIC_POWER = IntegerProperty.func_177719_a((String)"electric_power", (int)0, (int)15);

    public BaseElectricFence(AbstractBlock.Properties property, String name, ItemGroup group, boolean hasItem) {
        super(property.func_226896_b_().func_235838_a_(p -> 6), name, group, hasItem);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ELECTRIC_POWER});
    }

    public int updatePower(World worldIn, BlockPos pos) {
        int Largestpower = 0;
        for (Direction direction : Direction.values()) {
            int power;
            BlockState state = worldIn.func_180495_p(pos.func_177972_a(direction));
            Block block = state.func_177230_c();
            if (block instanceof EnergySupplierBlock && ((Boolean)state.func_177229_b((Property)EnergySupplierBlock.SUPPLYING)).booleanValue()) {
                return 15;
            }
            if (!(block instanceof BaseElectricFence) || !state.func_235901_b_((Property)ELECTRIC_POWER) || (power = ((Integer)state.func_177229_b((Property)ELECTRIC_POWER)).intValue()) <= Largestpower) continue;
            Largestpower = power - 1;
        }
        return Largestpower;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if ((Integer)state.func_177229_b((Property)ELECTRIC_POWER) > 0) {
            if (entityIn instanceof LivingEntity) {
                if (worldIn.func_72896_J() && worldIn.func_226660_f_(pos)) {
                    entityIn.func_70097_a(DamageSource.field_220302_v, 5.0f);
                    if (worldIn.field_72995_K) {
                        this.doCollideAnimation(pos, worldIn, 1, ParticleTypes.field_197594_E, SoundEvents.field_187646_bt, 0.75f, 50.0f);
                    }
                } else {
                    entityIn.func_70097_a(DamageSource.field_220302_v, 2.5f);
                    if (worldIn.field_72995_K) {
                        this.doCollideAnimation(pos, worldIn, 1, ParticleTypes.field_197601_L, SoundEvents.field_187646_bt, 0.55f, 20.0f);
                    }
                }
            } else {
                entityIn.func_70106_y();
                if (worldIn.field_72995_K) {
                    this.doCollideAnimation(pos, worldIn, 7, ParticleTypes.field_197601_L, SoundEvents.field_187646_bt, 0.8f, 20.0f);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doCollideAnimation(BlockPos pos, World worldIn, int amount, BasicParticleType particle, SoundEvent sound, float volume, float pitch) {
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        Random random = new Random();
        worldIn.func_184134_a(x + 0.5, y + 0.5, z + 0.5, sound, SoundCategory.BLOCKS, volume, pitch, false);
        for (int i = 0; i < amount; ++i) {
            worldIn.func_195594_a((IParticleData)particle, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((Property)ELECTRIC_POWER) == 0) {
            return;
        }
        if (rand.nextInt(300) == 1 && worldIn.field_72995_K) {
            this.doCollideAnimation(pos, worldIn, 1, ParticleTypes.field_197614_g, ModSounds.ELECTRIC_FENCE_IDLE, 0.05f, 1.0f);
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("can be dismantled by wrench, connect to a powered energy supplier or electric fence to activate"));
    }
}

