/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;

public class DevListCommand {
    private static int onlineMembersCount = 0;
    public static final HashMap<String, String> DEVELOPERS = new HashMap<String, String>(){
        {
            this.put("VeyezX(Vex)", "8ea51d9d-ccc9-4ce4-a9fd-9e8b5d1ceaf3");
            this.put("Kaneka", "df361308-a4b8-469c-a3b6-63bb8b2ec7e3");
            this.put("pupudice", "f0c9774d-e79f-4a58-b524-3f3d014e58ed");
            this.put("poopoodice", "b3fd2b3b-df09-4790-8187-650219671a69");
            this.put("BeerCav", "bc58f1ec-9853-4dd0-a0bb-da38cfaf6fe6");
            this.put("DinoSoup", "1dc30eef-5be5-4afa-9e1e-9a5c20df653f");
            this.put("MoonlitLamps", "");
            this.put("andrew0030", "0b37421b-e74e-4852-bf57-23907d295ea1");
            this.put("Setrion", "c5beef70-7f28-44c8-a1cc-91a1cc8836e6");
        }
    };
    public static final ArrayList<String> ARTISTS = new ArrayList<String>(){
        {
            this.add("VeyezX(Vex)");
            this.add("BeerCav");
            this.add("DinoSoup");
            this.add("MoonlitLamps");
            this.add("andrew0030");
        }
    };
    public static final ArrayList<String> AUTHORS = new ArrayList<String>(){
        {
            this.add("Kaneka");
            this.add("Poopoodice(pupudice)");
            this.add("Setrion");
        }
    };

    public static ArgumentBuilder<CommandSource, LiteralArgumentBuilder<CommandSource>> register(CommandDispatcher<CommandSource> dispatcher) {
        return Commands.func_197057_a((String)"devlist").executes(context -> {
            CommandSource src = (CommandSource)context.getSource();
            DevListCommand.send(src, DevListCommand.getFormattedText("----Plant Tech 2 Developers----", Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN), true, true));
            DevListCommand.send(src, DevListCommand.getFormattedText("Artist:", Color.func_240744_a_((TextFormatting)TextFormatting.AQUA), true, false));
            DevListCommand.printAllFromList(ARTISTS, src);
            DevListCommand.send(src, DevListCommand.getFormattedText("Authors:", Color.func_240744_a_((TextFormatting)TextFormatting.AQUA), true, false));
            DevListCommand.printAllFromList(AUTHORS, src);
            return onlineMembersCount;
        });
    }

    private static void printAllFromList(ArrayList<String> list, CommandSource src) {
        for (String username : list) {
            StringTextComponent status = new StringTextComponent("");
            if (DevListCommand.isOnline(src.func_197023_e(), username)) {
                status = DevListCommand.getFormattedText("(Online)", Color.func_240744_a_((TextFormatting)TextFormatting.GREEN), false, false);
                ++onlineMembersCount;
            }
            DevListCommand.send(src, DevListCommand.getText(username, status));
        }
    }

    private static UUID getUUID(String username) {
        return UUID.fromString(DEVELOPERS.get(username));
    }

    private static boolean isOnline(ServerWorld world, String username) {
        if (username.equals("Poopoodice(pupudice)")) {
            return world.func_217371_b(DevListCommand.getUUID("poopoodice")) != null || world.func_217371_b(DevListCommand.getUUID("pupudice")) != null;
        }
        if (username.equals("MoonlitLamps")) {
            return false;
        }
        return world.func_217371_b(DevListCommand.getUUID(username)) != null;
    }

    private static String getText(String name, StringTextComponent status) {
        return name + "  " + status.func_150265_g();
    }

    private static void send(CommandSource src, StringTextComponent msg) {
        src.func_197030_a((ITextComponent)msg, false);
    }

    private static void send(CommandSource src, String msg) {
        src.func_197030_a((ITextComponent)new StringTextComponent(msg), false);
    }

    private static StringTextComponent getFormattedText(String text, Color colour, boolean bold, boolean underline) {
        return (StringTextComponent)new StringTextComponent(text).func_230530_a_(Style.field_240709_b_.func_240718_a_(colour).func_240713_a_(Boolean.valueOf(bold)).setUnderlined(Boolean.valueOf(underline)));
    }
}

