/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datapack.reloadlistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.datapack.CropListEntryConfiguration;
import net.kaneka.planttech2.packets.CropConfigChangeMessage;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.io.IOUtils;

public class ReloadListenerCropListEntryConfiguration
implements IFutureReloadListener {
    public static final String PATH = "pt2_crops";
    public static final String EXTENTION = ".json";

    private void tryDeserialization(IResourceManager resourceManager, ResourceLocation file, Gson gson, Map<String, CropListEntryConfiguration> configs, boolean merge) {
        String name = file.func_110623_a().replace(PATH, "").replace(EXTENTION, "").replace("/", "");
        try (IResource iresource = resourceManager.func_199002_a(file);){
            JsonObject jsonobject = (JsonObject)JSONUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
            if (jsonobject == null) {
                PlantTechMain.LOGGER.error("Couldn't load recipe {} as it's null or empty", (Object)file);
            } else if (!merge) {
                configs.put(name, CropListEntryConfiguration.Deserializer.read(name, jsonobject));
            } else {
                configs.get(name).merge(CropListEntryConfiguration.Deserializer.read(name, jsonobject));
            }
        }
        catch (JsonParseException | IllegalArgumentException jsonparseexception) {
            PlantTechMain.LOGGER.error("Parsing error loading recipe {}", (Object)name, (Object)jsonparseexception);
        }
        catch (IOException ioexception) {
            PlantTechMain.LOGGER.error("Couldn't read custom advancement {} from {}", (Object)name, (Object)file, (Object)ioexception);
        }
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        PlantTechMain.LOGGER.info("Load crop configuration from data packs");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        HashMap<String, CropListEntryConfiguration> configs = new HashMap<String, CropListEntryConfiguration>();
        Collection files = resourceManager.func_199003_a(PATH, f -> f.endsWith(EXTENTION));
        for (ResourceLocation file2 : files.stream().filter(file -> file.func_110624_b().equals("planttech2")).collect(Collectors.toList())) {
            this.tryDeserialization(resourceManager, file2, gson, configs, false);
        }
        for (ResourceLocation file2 : files.stream().filter(file -> !file.func_110624_b().equals("planttech2")).collect(Collectors.toList())) {
            this.tryDeserialization(resourceManager, file2, gson, configs, true);
        }
        for (CropListEntryConfiguration config : configs.values()) {
            config.applyToEntry();
        }
        PlantTechMain.croplist.setConfigs(configs);
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            PlantTech2PacketHandler.sendTo(new CropConfigChangeMessage(configs), player);
        }
        CompletableFuture<Void> completablefuture = new CompletableFuture<Void>();
        completablefuture.complete(null);
        return completablefuture;
    }
}

