/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.kaneka.planttech2.entities.IAffectPlayerRadiation;
import net.kaneka.planttech2.entities.capabilities.player.RadiationEffect;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public abstract class TechCreatureEntity
extends CreatureEntity
implements IAffectPlayerRadiation {
    protected int passiveCooldown;
    protected static final UUID MOVEMENT_SPEED_MODIFIER = UUID.fromString("8FA5B460-E908-42ED-8203-573535F1912A");

    public TechCreatureEntity(EntityType<? extends TechCreatureEntity> type, World world) {
        super(type, world);
    }

    public void func_70071_h_() {
        int cooldown;
        super.func_70071_h_();
        if (this.passiveCooldown > 0) {
            --this.passiveCooldown;
        }
        if ((cooldown = this.getMaxPassiveCooldown() - this.getPassiveCooldown()) == this.getPassiveDuration()) {
            this.onPassiveEnds();
        } else if (this.isPassiveActive()) {
            this.onPassiveActive();
        }
        if (!this.field_70170_p.func_201670_d()) {
            ModifiableAttributeInstance attribute;
            if (this.matchPassiveCriteria() && this.onPassiveActivate()) {
                this.passiveCooldown = this.getMaxPassiveCooldown();
            }
            if ((attribute = this.func_110148_a(Attributes.field_233821_d_)) != null) {
                AttributeModifier modifier = attribute.func_111127_a(MOVEMENT_SPEED_MODIFIER);
                float amount = (this.func_110138_aP() - this.func_110143_aJ()) / this.func_110138_aP() * 0.03f;
                if (modifier != null && (this.isPassiveActive() || modifier.func_111164_d() != (double)amount)) {
                    attribute.func_188479_b(MOVEMENT_SPEED_MODIFIER);
                } else if (modifier == null) {
                    attribute.func_233769_c_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER, "Speed Modifier", (double)(-amount), AttributeModifier.Operation.ADDITION));
                }
            }
        }
        ++this.field_70708_bq;
        if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70708_bq > 300 && this.field_70708_bq % 12 == 0) {
            this.func_70691_i(Math.max(0.5f, (this.func_110138_aP() - this.func_110143_aJ()) / 30.0f));
            this.spawnParticles((IParticleData)ParticleTypes.field_197632_y);
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ModItems.BIOMASS && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(this.func_110138_aP() / 4.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.spawnParticles((IParticleData)ParticleTypes.field_197632_y);
            return ActionResultType.CONSUME;
        }
        return super.func_230254_b_(player, hand);
    }

    protected boolean matchPassiveCriteria() {
        return this.passiveCooldown <= 0 && !this.isPassiveActive() && this.func_110143_aJ() <= this.func_110138_aP() / 5.0f;
    }

    protected boolean onPassiveActivate() {
        this.spawnParticles((IParticleData)ParticleTypes.field_197627_t);
        this.func_195064_c(new EffectInstance(Effects.field_76424_c, 60));
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, 100));
        return true;
    }

    protected void onPassiveActive() {
        this.spawnParticles((IParticleData)ParticleTypes.field_197627_t);
    }

    protected void onPassiveEnds() {
        this.spawnParticles((IParticleData)ParticleTypes.field_197594_E);
    }

    protected void spawnParticles(IParticleData particle) {
        if (this.field_70170_p.func_201670_d()) {
            for (int i = 0; i < 7; ++i) {
                this.field_70170_p.func_195594_a(particle, this.func_226277_ct_() - (double)(this.func_213311_cf() / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()), this.func_226281_cx_() - (double)(this.func_213311_cf() / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()), 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("passivecooldown", this.passiveCooldown);
        super.func_213281_b(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.passiveCooldown = compound.func_74762_e("passivecooldown");
        super.func_70037_a(compound);
    }

    protected int getPassiveDuration() {
        return 100;
    }

    public boolean isPassiveActive() {
        return this.getMaxPassiveCooldown() - this.getPassiveCooldown() < this.getPassiveDuration();
    }

    protected int getMaxPassiveCooldown() {
        return 1200;
    }

    protected int getPassiveCooldown() {
        return this.passiveCooldown;
    }

    @Override
    public boolean shouldAffectPlayer() {
        return true;
    }

    @Override
    public void onTriggerAffectingPlayer(@Nonnull ServerPlayerEntity player) {
        RadiationEffect.getCap(player).increaseLevel(0.001f);
    }
}

