/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.enums;

import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public enum EnumTemperature {
    EXTREME_COLD(0, -1.0f, 0.0f, TextFormatting.BLUE),
    COLD(1, 0.0f, 0.5f, TextFormatting.AQUA),
    NORMAL(2, 0.5f, 1.0f, TextFormatting.GREEN),
    WARM(3, 1.0f, 1.5f, TextFormatting.YELLOW),
    EXTREME_WARM(4, 1.5f, 2.5f, TextFormatting.RED);

    private int id;
    private float min;
    private float max;
    private Color color;

    private EnumTemperature(int id, float min, float max, TextFormatting color) {
        this.id = id;
        this.min = min;
        this.max = max;
        this.color = Color.func_240744_a_((TextFormatting)color);
    }

    public static EnumTemperature byValue(float value) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (!(temp.min <= value) || !(temp.max > value)) continue;
            return temp;
        }
        return EXTREME_WARM;
    }

    public static EnumTemperature byId(int id) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (temp.id != id) continue;
            return temp;
        }
        return NORMAL;
    }

    public static EnumTemperature byName(String name) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (!temp.name().equals(name)) continue;
            return temp;
        }
        return NORMAL;
    }

    public IFormattableTextComponent getDisplayString(boolean coloured) {
        TranslationTextComponent str = new TranslationTextComponent("temp." + this.name());
        return coloured ? new StringTextComponent(str.getString()).func_230530_a_(Style.field_240709_b_.func_240718_a_(this.getColor())) : str;
    }

    public boolean inRange(float value, int tolerance) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (this.id - tolerance > temp.id || temp.id > this.id + tolerance || !(temp.min <= value) || !(temp.max > value)) continue;
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public Color getColor() {
        return this.color;
    }
}

