/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.events;

import net.kaneka.planttech2.entities.IAffectPlayerRadiation;
import net.kaneka.planttech2.entities.capabilities.player.IRadiationEffect;
import net.kaneka.planttech2.entities.capabilities.player.RadiationEffect;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.kaneka.planttech2.packets.SyncRadiationLevelMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="planttech2")
public class PlayerEvents {
    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && !event.getEntity().func_130014_f_().func_201670_d()) {
            PlayerEvents.syncRadiationCapWithClient((ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && !event.getEntity().func_130014_f_().func_201670_d()) {
            RadiationEffect.getCap((ServerPlayerEntity)player).setLevel(0.0f);
            PlayerEvents.syncRadiationCapWithClient((ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public static void playerTicking(TickEvent.PlayerTickEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingDamageEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (event.getEntityLiving() instanceof ServerPlayerEntity && !((ServerPlayerEntity)event.getEntityLiving()).field_71075_bZ.field_75098_d && trueSource instanceof IAffectPlayerRadiation && ((IAffectPlayerRadiation)trueSource).shouldAffectPlayer()) {
            ((IAffectPlayerRadiation)trueSource).onTriggerAffectingPlayer((ServerPlayerEntity)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        IRadiationEffect oldCap = RadiationEffect.getCap((ServerPlayerEntity)event.getOriginal());
        IRadiationEffect newCap = RadiationEffect.getCap((ServerPlayerEntity)event.getEntityLiving());
        if (event.isWasDeath()) {
            newCap.setLevel(oldCap.getLevel());
        } else {
            newCap.setLevel(0.0f);
        }
    }

    private static void syncRadiationCapWithClient(ServerPlayerEntity player) {
        PlantTech2PacketHandler.sendTo(new SyncRadiationLevelMessage(RadiationEffect.getCap(player).getLevel()), player);
    }
}

