/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.kaneka.planttech2.container.BaseContainer;
import net.kaneka.planttech2.gui.guide.Guide;
import net.kaneka.planttech2.gui.guide.GuideScreen;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class BaseContainerScreen<T extends BaseContainer>
extends ContainerScreen<T> {
    protected final PlayerInventory player;
    protected final EnergyTileEntity te;

    protected abstract ResourceLocation getBackgroundTexture();

    public BaseContainerScreen(BaseContainer inventorySlotsIn, PlayerInventory inventoryPlayer, ITextComponent title) {
        super((Container)inventorySlotsIn, inventoryPlayer, title);
        this.te = inventorySlotsIn.getTE();
        this.player = inventoryPlayer;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_146999_f = 208;
        this.field_147000_g = 200;
        this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2;
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.drawTooltips(mStack, mouseX, mouseY);
        this.func_230459_a_(mStack, mouseX, mouseY);
    }

    protected void drawTooltips(MatrixStack mStack, int mouseX, int mouseY) {
        this.drawTooltip(mStack, this.te.getEnergyStored() + "/" + this.te.getMaxEnergyStored(), mouseX, mouseY, 148, 27, 16, 55);
    }

    public void drawTooltip(MatrixStack mStack, String lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.field_147003_i) && mouseX <= posX + width && mouseY >= (posY += this.field_147009_r) && mouseY <= posY + height) {
            this.func_238652_a_(mStack, (ITextProperties)new StringTextComponent(lines), mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack mStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.getBackgroundTexture());
        this.func_238474_b_(mStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_230451_b_(MatrixStack mStack, int mouseX, int mouseY) {
        String tileName = this.field_230704_d_.getString();
        int textcolor = Integer.parseInt("000000", 16);
        this.field_230712_o_.func_238421_b_(mStack, tileName, (float)this.field_146999_f / 2.0f - (float)this.field_230712_o_.func_78256_a(tileName) / 2.0f + 1.0f, 14.0f, textcolor);
    }

    protected int getEnergyStoredScaled(int pixels) {
        int i = ((BaseContainer)this.field_147002_h).getValue(0);
        int j = ((BaseContainer)this.field_147002_h).getValue(1);
        return i != 0 && j != 0 ? i * pixels / j : 0;
    }

    protected int getFluidStoredScaled(int pixels) {
        int i = ((BaseContainer)this.field_147002_h).getValue(2);
        int j = ((BaseContainer)this.field_147002_h).getValue(3);
        return i != 0 && j != 0 ? i * pixels / j : 0;
    }

    protected void func_230459_a_(MatrixStack mStack, int x, int y) {
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && !this.field_147006_u.func_75216_d() && this.field_147006_u instanceof BaseContainer.SlotItemHandlerWithInfo) {
            this.func_238652_a_(mStack, (ITextProperties)new TranslationTextComponent(((BaseContainer.SlotItemHandlerWithInfo)this.field_147006_u).getUsageString()), x, y);
        } else {
            super.func_230459_a_(mStack, x, y);
        }
    }

    public boolean func_231044_a_(double posX, double posY, int buttonid) {
        if (posX - (double)this.field_147003_i >= 190.0 && posX - (double)this.field_147003_i <= 200.0 && posY - (double)this.field_147009_r >= 15.0 && posY - (double)this.field_147009_r <= 26.0) {
            Guide guide = new Guide();
            int menu = guide.getMenuByName(this.getGuideMenuString());
            int entry = guide.getEntryByName(menu, this.getGuideEntryString());
            Minecraft.func_71410_x().func_147108_a((Screen)new GuideScreen(menu, entry));
            return true;
        }
        return super.func_231044_a_(posX, posY, buttonid);
    }

    protected String getGuideMenuString() {
        return "machines";
    }

    protected abstract String getGuideEntryString();
}

