/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.EnergyStorageItem;
import net.kaneka.planttech2.tileentity.CropsTileEntity;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class AdvancedAnalyserItem
extends EnergyStorageItem {
    private static final int capacity = 1000;

    public AdvancedAnalyserItem() {
        super("advanced_analyser", new Item.Properties().func_200917_a(1).func_200916_a(ModCreativeTabs.groupmain), 1000);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack stack = ctx.func_195996_i();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof AdvancedAnalyserItem) {
            TileEntity te;
            World world = ctx.func_195991_k();
            BlockPos pos = ctx.func_195995_a();
            PlayerEntity player = ctx.func_195999_j();
            if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof CropsTileEntity) {
                CropsTileEntity cte = (CropsTileEntity)te;
                if (cte.isAnalysed()) {
                    HashMapCropTraits traits = cte.getTraits();
                    this.sendTraits(player, traits);
                } else if (this.currentEnergy(stack) >= AdvancedAnalyserItem.getEnergyCosts()) {
                    this.extractEnergy(stack, AdvancedAnalyserItem.getEnergyCosts(), false);
                    HashMapCropTraits traits = cte.setAnalysedAndGetTraits();
                    this.sendTraits(player, traits);
                } else {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Not enough energy"), player.func_110124_au());
                }
            }
        }
        return super.func_195939_a(ctx);
    }

    private void sendTraits(PlayerEntity player, HashMapCropTraits traits) {
        player.func_145747_a((ITextComponent)new StringTextComponent("--------------------------------------"), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.type").getString() + ": " + traits.getType()), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.soil").getString() + ": " + CropSeedItem.getSoilString(traits.getType())), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.growspeed").getString() + ": " + traits.getTrait(EnumTraitsInt.GROWSPEED)), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.sensitivity").getString() + ": " + traits.getTrait(EnumTraitsInt.SENSITIVITY)), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.needed_lightlevel").getString() + ": " + (14 - traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.waterrange").getString() + ": " + (1 + traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.temperature").getString() + ": ").func_230529_a_(CropSeedItem.temperatureString(traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE))), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.productivity").getString() + ": " + traits.getTrait(EnumTraitsInt.PRODUCTIVITY)), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.fertility").getString() + ": " + traits.getTrait(EnumTraitsInt.FERTILITY)), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.spreedingspeed").getString() + ": " + traits.getTrait(EnumTraitsInt.SPREEDINGSPEED)), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.genestrength").getString() + ": " + traits.getTrait(EnumTraitsInt.GENESTRENGHT)), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.energyvalue").getString() + ": " + traits.getTrait(EnumTraitsInt.ENERGYVALUE) * 20), player.func_110124_au());
    }

    private static int getEnergyCosts() {
        return 100;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new StringTextComponent("Rightclick on a crop to analyse traits"));
        tooltip.add((ITextComponent)new StringTextComponent("Analysing unknown traits consumes " + AdvancedAnalyserItem.getEnergyCosts() + " BE"));
    }
}

