/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.items.BaseItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.tileentity.CropsTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FertilizerItem
extends BaseItem {
    public FertilizerItem(String name, ItemGroup group) {
        super(name, new Item.Properties().func_200916_a(group));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof CropBaseBlock) {
            if (!context.func_195999_j().func_184812_l_()) {
                stack.func_190918_g(1);
            }
            if (field_77697_d.nextFloat() < this.getIncreaseChance(stack.func_77973_b()) && stack.func_77973_b() != ModItems.FERTILIZER_CREATIVE) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof CropsTileEntity) {
                    ((CropBaseBlock)block).updateCrop(world, pos, ((CropsTileEntity)te).getTraits());
                }
            } else if (stack.func_77973_b() == ModItems.FERTILIZER_CREATIVE) {
                ((CropBaseBlock)block).updateCreative(world, pos);
            }
        }
        return super.func_195939_a(context);
    }

    public float getIncreaseChance(Item item) {
        if (item == ModItems.FERTILIZER_TIER_1) {
            return 0.05f;
        }
        if (item == ModItems.FERTILIZER_TIER_2) {
            return 0.15f;
        }
        if (item == ModItems.FERTILIZER_TIER_3) {
            return 0.35f;
        }
        if (item == ModItems.FERTILIZER_TIER_4) {
            return 0.75f;
        }
        if (item == ModItems.FERTILIZER_CREATIVE) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.fertilizer").getString() + ": " + (int)(this.getIncreaseChance(stack.func_77973_b()) * 100.0f) + "%"));
        if (stack.func_77973_b() == ModItems.FERTILIZER_CREATIVE) {
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.fertilizer_creative").getString()));
        }
    }
}

