/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import net.kaneka.planttech2.blocks.FacingGrowingBlock;
import net.kaneka.planttech2.blocks.GrowingBlock;
import net.kaneka.planttech2.items.BaseItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MachineBulbItem
extends BaseItem {
    private Block crop;
    private Block hull;
    private int tier;
    private int neededBiomass;

    public MachineBulbItem(String name, Block hull, Block crop, int tier, int neededBiomass) {
        super(name, new Item.Properties().func_200916_a(ModCreativeTabs.groupseeds));
        this.hull = hull;
        this.crop = crop;
        this.tier = tier;
        this.neededBiomass = neededBiomass;
        ModItems.MACHINEBULBS.add(this);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        Block target = world.func_180495_p(pos).func_177230_c();
        ItemStack stack = ctx.func_195996_i();
        if (target != null && target.equals(this.hull)) {
            if (this.crop instanceof FacingGrowingBlock) {
                Direction direction = ctx.func_196000_l();
                if (!direction.equals((Object)Direction.DOWN) && !direction.equals((Object)Direction.UP)) {
                    world.func_175656_a(pos, (BlockState)this.crop.func_176223_P().func_206870_a((Property)FacingGrowingBlock.FACING, (Comparable)direction));
                    stack.func_190918_g(1);
                    return ActionResultType.CONSUME;
                }
            } else {
                world.func_175656_a(pos, this.crop.func_176223_P());
                stack.func_190918_g(1);
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.FAIL;
    }

    public int getTier() {
        return this.tier;
    }

    public Block getHull() {
        return this.hull;
    }

    public Block getCrop() {
        return this.crop;
    }

    public Block getMachine() {
        if (this.crop instanceof GrowingBlock) {
            return this.crop.getBlock();
        }
        return this.crop;
    }

    public int getNeededBiomass() {
        return this.neededBiomass;
    }
}

