/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.baseclasses.NaturalPlants;
import net.kaneka.planttech2.blocks.interfaces.IObtainable;
import net.kaneka.planttech2.items.BaseItem;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class PlantObtainerItem
extends BaseItem {
    public PlantObtainerItem(String name, Item.Properties property) {
        super(name, property.func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        IObtainable block;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = player.func_184614_ca();
        PlantObtainerItem.initTags(stack);
        if (state.func_177230_c() instanceof IObtainable) {
            IObtainable block2 = (IObtainable)state.func_177230_c();
            if (!PlantObtainerItem.isFilled(stack) && block2.isObtainable(context)) {
                PlantObtainerItem.setBlockFilled(stack, block2.getObtainedBlockState(state));
                block2.onObtained(world, player, stack, pos);
                return ActionResultType.SUCCESS;
            }
        } else if (PlantObtainerItem.isFilled(stack) && ((NaturalPlants)((Object)(block = (IObtainable)PlantObtainerItem.getBlockStateFilled(stack).func_177230_c()))).canPlaceAt(world, pos.func_177972_a(context.func_196000_l()))) {
            block.onReleased(context, PlantObtainerItem.getBlockStateFilled(stack));
            PlantObtainerItem.setBlockFilled(stack, null);
            PlantObtainerItem.setFilled(stack, false);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static ItemStack setBlockFilled(ItemStack stack, BlockState state) {
        CompoundNBT compound;
        CompoundNBT compoundNBT = compound = stack.func_77942_o() ? stack.func_77978_p() : PlantObtainerItem.initTags(stack).func_77978_p();
        if (state == Blocks.field_150350_a.func_176223_P() || state != null) {
            compound.func_197643_a(NBTUtil.func_190009_a((BlockState)state));
            PlantObtainerItem.setFilled(stack, true);
        } else {
            NBTUtil.func_190009_a((BlockState)Blocks.field_150350_a.func_176223_P());
            PlantObtainerItem.setFilled(stack, false);
        }
        stack.func_77982_d(compound);
        return stack;
    }

    public static BlockState getBlockStateFilled(ItemStack stack) {
        CompoundNBT compound = stack.func_77942_o() ? stack.func_77978_p() : PlantObtainerItem.initTags(stack).func_77978_p();
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)compound);
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return null;
        }
        PlantObtainerItem.setFilled(stack, true);
        return state;
    }

    public static ItemStack setFilled(ItemStack stack, boolean filled) {
        CompoundNBT compound;
        CompoundNBT compoundNBT = compound = stack.func_77942_o() ? stack.func_77978_p() : PlantObtainerItem.initTags(stack).func_77978_p();
        if (!filled) {
            compound.func_197643_a(NBTUtil.func_190009_a((BlockState)Blocks.field_150350_a.func_176223_P()));
        }
        compound.func_74757_a("filled", filled);
        stack.func_77982_d(compound);
        return stack;
    }

    public static boolean isFilled(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("filled") && PlantObtainerItem.getBlockStateFilled(stack) != null;
    }

    public static ItemStack initTags(ItemStack stack) {
        CompoundNBT compound = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        stack.func_77982_d(compound);
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("Right click on an unique plants found planttopia to obtain and store it in the void"));
        tooltip.add((ITextComponent)new StringTextComponent("Right click again to get it back"));
        PlantObtainerItem.initTags(stack);
        if (PlantObtainerItem.isFilled(stack)) {
            tooltip.add((ITextComponent)new StringTextComponent("Plant Obtained: ").func_230529_a_((ITextComponent)PlantObtainerItem.getBlockStateFilled(stack).func_177230_c().func_235333_g_().func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN)).func_240713_a_(Boolean.valueOf(true)))));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("Empty").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN)).func_240713_a_(Boolean.valueOf(true))));
        }
    }
}

