/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.kaneka.planttech2.items.armors.ArmorBaseItem;
import net.kaneka.planttech2.items.armors.CustomArmorMaterial;
import net.kaneka.planttech2.items.upgradeable.BaseUpgradeableItem;
import net.kaneka.planttech2.items.upgradeable.IUpgradeable;
import net.kaneka.planttech2.items.upgradeable.InventoryEnergyProvider;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class UpgradeableArmorItem
extends ArmorBaseItem
implements IItemChargeable,
IUpgradeable {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private int basecapacity;
    private int maxInvSize;
    private int baseDamageReduction;
    private int slotId;
    private float baseToughness;

    public UpgradeableArmorItem(String name, String resname, EquipmentSlotType slot, int basecapacity, int maxInvSize, int baseDamageReduction, float baseToughness, int slotId) {
        super(name, resname, CustomArmorMaterial.UNNECESSARY, slot, new Item.Properties().func_200916_a(ModCreativeTabs.groupToolsAndArmor));
        this.basecapacity = basecapacity;
        this.maxInvSize = maxInvSize;
        this.baseDamageReduction = baseDamageReduction;
        this.baseToughness = baseToughness;
        this.slotId = slotId;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new InventoryEnergyProvider(this.basecapacity, this.maxInvSize);
    }

    public void updateEnergy(ItemStack stack) {
        IEnergyStorage storage;
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        if ((storage = UpgradeableArmorItem.getEnergyCap(stack)) instanceof BioEnergyStorage) {
            tag.func_74768_a("current_energy", ((BioEnergyStorage)storage).getEnergyStored());
            tag.func_74768_a("max_energy", ((BioEnergyStorage)storage).getMaxEnergyStored());
        }
        stack.func_77982_d(tag);
    }

    @Override
    public int receiveEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = UpgradeableArmorItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.receiveEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = UpgradeableArmorItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.extractEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int maxEnergy(ItemStack stack) {
        IEnergyStorage storage = UpgradeableArmorItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public int currentEnergy(ItemStack stack) {
        IEnergyStorage storage = UpgradeableArmorItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    public static IEnergyStorage getEnergyCap(ItemStack stack) {
        LazyOptional provider = stack.getCapability(CapabilityEnergy.ENERGY);
        if (provider != null) {
            return (IEnergyStorage)provider.orElse(null);
        }
        return null;
    }

    public static IItemHandler getInvCap(ItemStack stack) {
        LazyOptional provider = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (provider != null) {
            return (IItemHandler)provider.orElse(null);
        }
        return null;
    }

    public static int getEnergyCost(ItemStack stack) {
        return 20 + NBTHelper.getIntSave(stack, "energycost", 0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !(this.getDurabilityForDisplay(stack) >= 1.0);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            return 1.0 - (double)tag.func_74762_e("current_energy") / (double)tag.func_74762_e("max_energy");
        }
        return 1.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Integer.parseInt("06bc00", 16);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public static int getInventorySize(ItemStack stack) {
        IItemHandler handler = UpgradeableArmorItem.getInvCap(stack);
        if (handler != null) {
            return handler.getSlots();
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_213453_ef() && !world.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new BaseUpgradeableItem.NamedContainerProvider(stack, player.field_71071_by.field_70461_c), buffer -> buffer.func_150788_a(stack));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public void updateNBTValues(ItemStack stack) {
        IItemHandler inv = UpgradeableArmorItem.getInvCap(stack);
        if (inv != null) {
            int energyCost = 0;
            int increaseCapacity = 0;
            int energyProduction = 0;
            int increaseArmor = 0;
            float increaseToughness = 0.0f;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack slot = inv.getStackInSlot(i);
                if (slot.func_190926_b() || !(slot.func_77973_b() instanceof UpgradeChipItem)) continue;
                UpgradeChipItem item = (UpgradeChipItem)slot.func_77973_b();
                energyCost += item.getEnergyCost();
                increaseCapacity += item.getIncreaseCapacity();
                energyProduction += item.getEnergyProduction();
                increaseArmor += item.getIncreaseArmor();
                increaseToughness += item.getIncreaseToughness();
                Enchantment ench = item.getEnchantment();
                if (!item.isAllowed(this.getSlotId()) || ench == null) continue;
                if (enchantments.containsKey(ench)) {
                    int nextlevel = (Integer)enchantments.get(ench) + 1;
                    enchantments.put(ench, nextlevel);
                    continue;
                }
                enchantments.put(ench, 1);
            }
            stack.func_77986_q().clear();
            for (Enchantment ench : enchantments.keySet()) {
                int level = (Integer)enchantments.get(ench);
                if (ench.func_77325_b() < level) {
                    stack.func_77966_a(ench, ench.func_77325_b());
                    continue;
                }
                stack.func_77966_a(ench, level);
            }
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            nbt.func_74768_a("energycost", energyCost);
            nbt.func_74768_a("energyproduction", energyProduction);
            nbt.func_74768_a("increasearmor", increaseArmor);
            nbt.func_74776_a("increasetoughness", increaseToughness);
            stack.func_77982_d(nbt);
            IEnergyStorage energy = UpgradeableArmorItem.getEnergyCap(stack);
            if (energy != null && energy instanceof BioEnergyStorage) {
                ((BioEnergyStorage)energy).setEnergyMaxStored(this.basecapacity + increaseCapacity);
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == this.field_77881_a) {
            multimap.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", (double)this.getDamageReduceAmount(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor toughness", (double)this.getToughness(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public int getDamageReduceAmount(ItemStack stack) {
        return this.baseDamageReduction + NBTHelper.getIntSave(stack, "increasearmor", 0);
    }

    public float getToughness(ItemStack stack) {
        return this.baseToughness + NBTHelper.getFloatSave(stack, "increasetoughness", 0);
    }

    public boolean func_77645_m() {
        return false;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!world.field_72995_K && !stack.func_190926_b() && world.func_82737_E() % 200L == 0L) {
            this.receiveEnergy(stack, NBTHelper.getIntSave(stack, "energyproduction", 0), false);
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.energy", new Object[]{tag.func_74762_e("current_energy") + "/" + tag.func_74762_e("max_energy")}));
            tooltip.add((ITextComponent)new TranslationTextComponent("info.energycosts", new Object[]{UpgradeableArmorItem.getEnergyCost(stack)}));
            tooltip.add((ITextComponent)new TranslationTextComponent("info.openwithshift"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getSlotId() {
        return this.slotId;
    }
}

