/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.librarys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kaneka.planttech2.datapack.CropListEntryConfiguration;
import net.kaneka.planttech2.librarys.CropListEntry;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class CropList {
    private HashMap<String, CropListEntry> croplist = new HashMap();
    private Map<String, CropListEntryConfiguration> configs = new HashMap<String, CropListEntryConfiguration>();
    private int nextID = 0;

    public void addEntry(String name, int seedColor, boolean hasParticle) {
        this.croplist.put(name, new CropListEntry(this.nextID, name, seedColor, hasParticle));
        ++this.nextID;
    }

    public void removeEntry(String name) {
        this.croplist.remove(name);
    }

    public Set<String> getAllKeys() {
        return this.croplist.keySet();
    }

    public Collection<CropListEntry> getAllEntries() {
        return this.croplist.values();
    }

    public List<String> getAllEntriesWithoutBlacklisted() {
        ArrayList<String> list = new ArrayList<String>();
        for (CropListEntry entry : this.croplist.values()) {
            if (entry.isBlacklisted()) continue;
            list.add(entry.getString());
        }
        Collections.sort(list);
        return list;
    }

    public Set<String> getAllWithParticles() {
        HashSet<String> keys = new HashSet<String>();
        for (CropListEntry entry : this.getAllEntries()) {
            if (!entry.hasParticle()) continue;
            keys.add(entry.getString());
        }
        return keys;
    }

    public CropListEntry getEntryByName(String name) {
        return this.croplist.get(name);
    }

    public CropListEntry getBySeed(ItemStack item) {
        CropListEntry returnvalue = null;
        for (CropListEntry entry : this.croplist.values()) {
            if (!entry.isSeed(item)) continue;
            returnvalue = entry;
            break;
        }
        return returnvalue;
    }

    public CropListEntry getByID(int id) {
        CropListEntry returnvalue = null;
        for (CropListEntry entry : this.croplist.values()) {
            if (entry.getID() != id) continue;
            returnvalue = entry;
            break;
        }
        return returnvalue;
    }

    public Set<CropListEntry> getByParents(String parent1, String parent2) {
        HashSet<CropListEntry> returnvalue = new HashSet<CropListEntry>();
        for (CropListEntry entry : this.croplist.values()) {
            if (!entry.isChild(parent1, parent2)) continue;
            returnvalue.add(entry);
        }
        return returnvalue;
    }

    public void setConfigs(Map<String, CropListEntryConfiguration> newConfigs) {
        this.configs = newConfigs;
    }

    public Map<String, CropListEntryConfiguration> getConfigs() {
        return this.configs;
    }

    public void setMainSeeds() {
        for (CropListEntry entry : this.croplist.values()) {
            entry.setMainSeed(new ItemStack((IItemProvider)ModItems.SEEDS.get(entry.getString())), 1, 4);
        }
    }

    public void setParticles() {
        for (CropListEntry entry : this.getAllEntries()) {
            if (!entry.hasParticle()) continue;
            entry.addDrop(new ItemStack((IItemProvider)ModItems.PARTICLES.get(entry.getString())), 0, 8);
        }
    }

    public int getLength() {
        return this.nextID;
    }

    public int getLengthWithoutBlacklisted() {
        int i = 0;
        for (CropListEntry entry : this.getAllEntries()) {
            if (!entry.isBlacklisted()) continue;
            ++i;
        }
        return this.nextID - i;
    }

    public void addPlanttechEntries() {
        this.addEntry("abyssalnite", Integer.parseInt("45005f", 16), true);
        this.addEntry("adamantine", Integer.parseInt("d53c00", 16), true);
        this.addEntry("allium", Integer.parseInt("a65ee1", 16), false);
        this.addEntry("aluminum", Integer.parseInt("b4b4b4", 16), true);
        this.addEntry("aluminum_brass", Integer.parseInt("c8b300", 16), true);
        this.addEntry("alumite", Integer.parseInt("e789ff", 16), true);
        this.addEntry("amber", Integer.parseInt("e09e00", 16), true);
        this.addEntry("apatite", Integer.parseInt("00b3e0", 16), true);
        this.addEntry("aquamarine", Integer.parseInt("00c3d4", 16), true);
        this.addEntry("ardite", Integer.parseInt("88471b", 16), true);
        this.addEntry("awakened_draconium", Integer.parseInt("bf4c00", 16), true);
        this.addEntry("azure_bluet", Integer.parseInt("d6e8e8", 16), false);
        this.addEntry("bamboo", Integer.parseInt("5d8824", 16), false);
        this.addEntry("basalt", Integer.parseInt("424242", 16), true);
        this.addEntry("beast", Integer.parseInt("6a6965", 16), true);
        this.addEntry("beetroots", Integer.parseInt("bf2529", 16), false);
        this.addEntry("black_quartz", Integer.parseInt("202020", 16), true);
        this.addEntry("blaze", Integer.parseInt("fc9600", 16), true);
        this.addEntry("blitz", Integer.parseInt("fffdcc", 16), true);
        this.addEntry("blizz", Integer.parseInt("c3d3ff", 16), true);
        this.addEntry("blue_topaz", Integer.parseInt("6089ff", 16), true);
        this.addEntry("blue_orchid", Integer.parseInt("3066ff", 16), false);
        this.addEntry("brass", Integer.parseInt("eaeaea", 16), true);
        this.addEntry("bronze", Integer.parseInt("804500", 16), true);
        this.addEntry("cactus", Integer.parseInt("527d26", 16), false);
        this.addEntry("carrot", Integer.parseInt("e38a1d", 16), false);
        this.addEntry("certus_quartz", Integer.parseInt("9fc3ff", 16), true);
        this.addEntry("chicken", Integer.parseInt("e2e2e2", 16), true);
        this.addEntry("chimerite", Integer.parseInt("aeffa6", 16), true);
        this.addEntry("chorus", Integer.parseInt("8f718f", 16), false);
        this.addEntry("chrome", Integer.parseInt("FFFFFF", 16), true);
        this.addEntry("coal", Integer.parseInt("3f3f3f", 16), true);
        this.addEntry("cobalt", Integer.parseInt("1d5791", 16), true);
        this.addEntry("cocoa_bean", Integer.parseInt("b97335", 16), false);
        this.addEntry("cold_iron", Integer.parseInt("72a7ff", 16), true);
        this.addEntry("compressed_iron", Integer.parseInt("bdbdbd", 16), true);
        this.addEntry("conductive_iron", Integer.parseInt("629dff", 16), true);
        this.addEntry("constantan", Integer.parseInt("b1ab00", 16), true);
        this.addEntry("copper", Integer.parseInt("b47800", 16), true);
        this.addEntry("coralium", Integer.parseInt("00646a", 16), true);
        this.addEntry("cornflower", Integer.parseInt("466aeb", 16), false);
        this.addEntry("cow", Integer.parseInt("443626", 16), true);
        this.addEntry("creeper", Integer.parseInt("41b736", 16), true);
        this.addEntry("dancium", Integer.parseInt("eb8c14", 16), true);
        this.addEntry("dandelion", Integer.parseInt("fed639", 16), false);
        this.addEntry("dark_gem", Integer.parseInt("4e4e4e", 16), true);
        this.addEntry("dark_steel", Integer.parseInt("8d7aff", 16), true);
        this.addEntry("desh", Integer.parseInt("535353", 16), true);
        this.addEntry("diamond", Integer.parseInt("77cefb", 16), true);
        this.addEntry("dirt", Integer.parseInt("593d29", 16), true);
        this.addEntry("draconium", Integer.parseInt("7600ba", 16), true);
        this.addEntry("dreadium", Integer.parseInt("ba000d", 16), true);
        this.addEntry("drowned", Integer.parseInt("8ff1d7", 16), true);
        this.addEntry("electrical_steel", Integer.parseInt("b8b8b8", 16), true);
        this.addEntry("electrotine", Integer.parseInt("005093", 16), true);
        this.addEntry("electrum", Integer.parseInt("fff158", 16), true);
        this.addEntry("elementium", Integer.parseInt("eb11ff", 16), true);
        this.addEntry("emerald", Integer.parseInt("17dd62", 16), true);
        this.addEntry("end_steel", Integer.parseInt("feffd6", 16), true);
        this.addEntry("ender_amethyst", Integer.parseInt("fd35ff", 16), true);
        this.addEntry("ender_biotite", Integer.parseInt("000000", 16), true);
        this.addEntry("enderdragon", Integer.parseInt("181818", 16), true);
        this.addEntry("enderium", Integer.parseInt("007b77", 16), true);
        this.addEntry("enderman", Integer.parseInt("181818", 16), true);
        this.addEntry("endstone", Integer.parseInt("f6fabd", 16), true);
        this.addEntry("energetic_alloy", Integer.parseInt("9cff32", 16), true);
        this.addEntry("fish", Integer.parseInt("bf841b", 16), true);
        this.addEntry("fluix_crystal", Integer.parseInt("6f0098", 16), true);
        this.addEntry("fluxed_electrum", Integer.parseInt("fffb87", 16), true);
        this.addEntry("ghast", Integer.parseInt("f0f0f0", 16), true);
        this.addEntry("glowstone", Integer.parseInt("fbda74", 16), true);
        this.addEntry("glowstone_ingot", Integer.parseInt("f6ed00", 16), true);
        this.addEntry("gold", Integer.parseInt("f8af2b", 16), true);
        this.addEntry("graphite", Integer.parseInt("444444", 16), true);
        this.addEntry("guardian", Integer.parseInt("668980", 16), true);
        this.addEntry("husk", Integer.parseInt("6a5d4a", 16), true);
        this.addEntry("illager", Integer.parseInt("939999", 16), true);
        this.addEntry("invar", Integer.parseInt("c3bc00", 16), true);
        this.addEntry("iridium", Integer.parseInt("cfcfcf", 16), true);
        this.addEntry("iron", Integer.parseInt("bc9980", 16), true);
        this.addEntry("kanekium", Integer.parseInt("572e8a", 16), true);
        this.addEntry("kelp", Integer.parseInt("5b8131", 16), false);
        this.addEntry("kinnoium", Integer.parseInt("246b2d", 16), true);
        this.addEntry("knightslime", Integer.parseInt("fd5fff", 16), true);
        this.addEntry("lapis", Integer.parseInt("1044ac", 16), true);
        this.addEntry("lava", Integer.parseInt("d14f0c", 16), true);
        this.addEntry("lead", Integer.parseInt("326e99", 16), true);
        this.addEntry("lenthurium", Integer.parseInt("2c8585", 16), true);
        this.addEntry("lilly_of_the_valley", Integer.parseInt("e7e7e7", 16), false);
        this.addEntry("lithium", Integer.parseInt("fffac4", 16), true);
        this.addEntry("lumium", Integer.parseInt("fff282", 16), true);
        this.addEntry("magma_cube", Integer.parseInt("330000", 16), true);
        this.addEntry("magnesium", Integer.parseInt("615900", 16), true);
        this.addEntry("malachite", Integer.parseInt("36bf53", 16), true);
        this.addEntry("manasteel", Integer.parseInt("3d8fff", 16), true);
        this.addEntry("manyullyn", Integer.parseInt("793393", 16), true);
        this.addEntry("melon", Integer.parseInt("a7ac1d", 16), false);
        this.addEntry("meteoric_iron", Integer.parseInt("8f845e", 16), true);
        this.addEntry("mithril", Integer.parseInt("b7d7ff", 16), true);
        this.addEntry("moonstone", Integer.parseInt("eef6ff", 16), true);
        this.addEntry("mooshroom", Integer.parseInt("a81012", 16), true);
        this.addEntry("mushroom", Integer.parseInt("e21212", 16), false);
        this.addEntry("mycelium", Integer.parseInt("736162", 16), true);
        this.addEntry("nether_wart", Integer.parseInt("831c20", 16), false);
        this.addEntry("netherrack", Integer.parseInt("652828", 16), true);
        this.addEntry("neutronium", Integer.parseInt("585858", 16), true);
        this.addEntry("nickel", Integer.parseInt("9f998c", 16), true);
        this.addEntry("octine", Integer.parseInt("ffb400", 16), true);
        this.addEntry("orange_tulip", Integer.parseInt("bd6a22", 16), false);
        this.addEntry("osmium", Integer.parseInt("c6edff", 16), true);
        this.addEntry("oxeye_daisy", Integer.parseInt("f5ba27", 16), false);
        this.addEntry("panda", Integer.parseInt("f5ba27", 16), true);
        this.addEntry("parrot", Integer.parseInt("18bdff", 16), true);
        this.addEntry("peridot", Integer.parseInt("5fc859", 16), true);
        this.addEntry("pig", Integer.parseInt("f19e98", 16), true);
        this.addEntry("pink_tulip", Integer.parseInt("e4aff4", 16), false);
        this.addEntry("plantium", Integer.parseInt("35a048", 16), true);
        this.addEntry("platinum", Integer.parseInt("a2a2a2", 16), true);
        this.addEntry("polarbear", Integer.parseInt("f6f6f6", 16), true);
        this.addEntry("poppy", Integer.parseInt("ed302c", 16), false);
        this.addEntry("potato", Integer.parseInt("c8a24b", 16), false);
        this.addEntry("prismarin", Integer.parseInt("5ea496", 16), true);
        this.addEntry("pulsating_iron", Integer.parseInt("75d970", 16), true);
        this.addEntry("pumpkin", Integer.parseInt("e38a1d", 16), false);
        this.addEntry("quartz", Integer.parseInt("d4caba", 16), true);
        this.addEntry("quicksilver", Integer.parseInt("d6ffff", 16), true);
        this.addEntry("red_tulip", Integer.parseInt("ed302c", 16), false);
        this.addEntry("redstone", Integer.parseInt("ff0000", 16), true);
        this.addEntry("redstone_alloy", Integer.parseInt("ff0000", 16), true);
        this.addEntry("refined_obsidian", Integer.parseInt("62316d", 16), true);
        this.addEntry("rock_crystal", Integer.parseInt("a6a6a6", 16), true);
        this.addEntry("rubber", Integer.parseInt("444444", 16), true);
        this.addEntry("ruby", Integer.parseInt("980000", 16), true);
        this.addEntry("saltpeter", Integer.parseInt("969696", 16), true);
        this.addEntry("sand", Integer.parseInt("dacfa3", 16), true);
        this.addEntry("sapphire", Integer.parseInt("000a8e", 16), true);
        this.addEntry("sheep", Integer.parseInt("c09e86", 16), true);
        this.addEntry("shulker", Integer.parseInt("8e608e", 16), true);
        this.addEntry("signalum", Integer.parseInt("8e5700", 16), true);
        this.addEntry("silicon", Integer.parseInt("777777", 16), true);
        this.addEntry("silver", Integer.parseInt("dadada", 16), true);
        this.addEntry("skeleton", Integer.parseInt("bcbcbc", 16), true);
        this.addEntry("sky_stone", Integer.parseInt("383838", 16), true);
        this.addEntry("slate", Integer.parseInt("FFFFFF", 16), true);
        this.addEntry("slime", Integer.parseInt("59bd45", 16), true);
        this.addEntry("slimy_bone", Integer.parseInt("7b7b7b", 16), true);
        this.addEntry("snow", Integer.parseInt("ffffff", 16), true);
        this.addEntry("soularium", Integer.parseInt("443824", 16), true);
        this.addEntry("soulsand", Integer.parseInt("49372c", 16), true);
        this.addEntry("spider", Integer.parseInt("605448", 16), true);
        this.addEntry("sponge", Integer.parseInt("cdce4a", 16), true);
        this.addEntry("squid", Integer.parseInt("cdce4a", 16), true);
        this.addEntry("star_steel", Integer.parseInt("171717", 16), true);
        this.addEntry("starmetal", Integer.parseInt("22002f", 16), true);
        this.addEntry("steel", Integer.parseInt("686868", 16), true);
        this.addEntry("stone", Integer.parseInt("616161", 16), true);
        this.addEntry("stray", Integer.parseInt("acbabd", 16), true);
        this.addEntry("sugarcane", Integer.parseInt("82a859", 16), false);
        this.addEntry("sulfur", Integer.parseInt("b1ac27", 16), true);
        this.addEntry("sunstone", Integer.parseInt("c13b00", 16), true);
        this.addEntry("syrmorite", Integer.parseInt("c71eff", 16), true);
        this.addEntry("tanzanite", Integer.parseInt("a951c6", 16), true);
        this.addEntry("terrasteel", Integer.parseInt("32b100", 16), true);
        this.addEntry("thaumium", Integer.parseInt("8a00ff", 16), true);
        this.addEntry("tin", Integer.parseInt("aba78c", 16), true);
        this.addEntry("titanium", Integer.parseInt("c6c6c6", 16), true);
        this.addEntry("topaz", Integer.parseInt("ffde29", 16), true);
        this.addEntry("tungsten", Integer.parseInt("005a40", 16), true);
        this.addEntry("turtle", Integer.parseInt("388d3a", 16), true);
        this.addEntry("uranium", Integer.parseInt("3abd22", 16), true);
        this.addEntry("valonite", Integer.parseInt("cfa5d5", 16), true);
        this.addEntry("vibrant_alloy", Integer.parseInt("bf7e00", 16), true);
        this.addEntry("villager", Integer.parseInt("b57b67", 16), true);
        this.addEntry("vine", Integer.parseInt("1b5011", 16), false);
        this.addEntry("vinteum", Integer.parseInt("5a81ff", 16), true);
        this.addEntry("void_metal", Integer.parseInt("000000", 16), true);
        this.addEntry("water", Integer.parseInt("2b5fff", 16), true);
        this.addEntry("wheat", Integer.parseInt("ae19", 16), false);
        this.addEntry("white_tulip", Integer.parseInt("f7f7f7", 16), false);
        this.addEntry("witch", Integer.parseInt("a39483", 16), true);
        this.addEntry("wither", Integer.parseInt("343434", 16), true);
        this.addEntry("wither_rose", Integer.parseInt("000000", 16), false);
        this.addEntry("wither_skeleton", Integer.parseInt("515353", 16), true);
        this.addEntry("wood", Integer.parseInt("605e54", 16), true);
        this.addEntry("yellorium", Integer.parseInt("fffc00", 16), true);
        this.addEntry("zinc", Integer.parseInt("b8b78b", 16), true);
        this.addEntry("zombie", Integer.parseInt("71955b", 16), true);
        this.addEntry("zombie_pigman", Integer.parseInt("eea5a4", 16), true);
        this.addEntry("zombie_villager", Integer.parseInt("3b622f", 16), true);
    }

    public void configurePlanttechEntries() {
        this.setMainSeeds();
        this.setParticles();
        this.getEntryByName("allium").addSeeds(new ItemStack((IItemProvider)Blocks.field_196609_bf)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221622_aX), 0, 4);
        this.getEntryByName("azure_bluet").addSeeds(new ItemStack((IItemProvider)Blocks.field_196610_bg)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221623_aY), 0, 4);
        this.getEntryByName("blue_orchid").addSeeds(new ItemStack((IItemProvider)Blocks.field_196607_be)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221621_aW), 0, 4);
        this.getEntryByName("cornflower").addSeeds(new ItemStack((IItemProvider)Blocks.field_222387_by)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221686_be), 0, 4);
        this.getEntryByName("dandelion").addSeeds(new ItemStack((IItemProvider)Blocks.field_196605_bc)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221619_aU), 0, 4);
        this.getEntryByName("lilly_of_the_valley").addSeeds(new ItemStack((IItemProvider)Items.field_221688_bf)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221688_bf), 0, 4);
        this.getEntryByName("orange_tulip").addSeeds(new ItemStack((IItemProvider)Items.field_221678_ba)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221678_ba), 0, 4);
        this.getEntryByName("oxeye_daisy").addSeeds(new ItemStack((IItemProvider)Items.field_221684_bd)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221684_bd), 0, 4);
        this.getEntryByName("pink_tulip").addSeeds(new ItemStack((IItemProvider)Items.field_221682_bc)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221682_bc), 0, 4);
        this.getEntryByName("poppy").addSeeds(new ItemStack((IItemProvider)Items.field_221620_aV)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221620_aV), 0, 4);
        this.getEntryByName("red_tulip").addSeeds(new ItemStack((IItemProvider)Items.field_221624_aZ)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Items.field_221624_aZ), 0, 4);
        this.getEntryByName("white_tulip").addSeeds(new ItemStack((IItemProvider)Items.field_221680_bb)).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((IItemProvider)Blocks.field_196614_bj), 0, 4);
        this.getEntryByName("bamboo").addSeeds(new ItemStack((IItemProvider)Items.field_222068_kQ)).addDrop(new ItemStack((IItemProvider)Items.field_222068_kQ), 0, 4);
        this.getEntryByName("beetroots").addSeeds(new ItemStack((IItemProvider)Items.field_185163_cU)).addDrop(new ItemStack((IItemProvider)Items.field_185164_cV), 0, 4);
        this.getEntryByName("cactus").addSeeds(new ItemStack((IItemProvider)Items.field_221774_cw)).addDrop(new ItemStack((IItemProvider)Items.field_221774_cw), 0, 4);
        this.getEntryByName("carrot").addSeeds(new ItemStack((IItemProvider)Items.field_151172_bF)).addDrop(new ItemStack((IItemProvider)Items.field_151172_bF), 0, 4);
        this.getEntryByName("chorus").addSeeds(new ItemStack((IItemProvider)Items.field_221663_bT)).addDrop(new ItemStack((IItemProvider)Items.field_185161_cS), 0, 4);
        this.getEntryByName("cocoa_bean").addSeeds(new ItemStack((IItemProvider)Items.field_196130_bo)).addDrop(new ItemStack((IItemProvider)Items.field_196130_bo), 0, 4).addDrop(new ItemStack((IItemProvider)ModItems.COLOR_PARTICLES), 1, 4);
        this.getEntryByName("kelp").addSeeds(new ItemStack((IItemProvider)Items.field_222066_kO)).addDrop(new ItemStack((IItemProvider)Items.field_222066_kO), 0, 4);
        this.getEntryByName("melon").addSeeds(new ItemStack((IItemProvider)Items.field_151081_bc)).addDrop(new ItemStack((IItemProvider)Items.field_221794_dg), 0, 3);
        this.getEntryByName("mushroom").addSeeds(new ItemStack((IItemProvider)Items.field_221694_bi), new ItemStack((IItemProvider)Items.field_221692_bh)).addDrop(new ItemStack((IItemProvider)Items.field_221694_bi), 0, 4).addDrop(new ItemStack((IItemProvider)Items.field_221692_bh), 0, 4);
        this.getEntryByName("nether_wart").addSeeds(new ItemStack((IItemProvider)Items.field_151075_bm)).addDrop(new ItemStack((IItemProvider)Items.field_151075_bm), 0, 4);
        this.getEntryByName("potato").addSeeds(new ItemStack((IItemProvider)Items.field_151174_bG)).addDrop(new ItemStack((IItemProvider)Items.field_151174_bG), 0, 4).addDrop(new ItemStack((IItemProvider)Items.field_151170_bI), 0, 2);
        this.getEntryByName("pumpkin").addSeeds(new ItemStack((IItemProvider)Items.field_151080_bb)).addDrop(new ItemStack((IItemProvider)Items.field_221687_cF), 0, 3);
        this.getEntryByName("sugarcane").addSeeds(new ItemStack((IItemProvider)Items.field_222065_kN)).addDrop(new ItemStack((IItemProvider)Items.field_222065_kN), 0, 4);
        this.getEntryByName("vine").addSeeds(new ItemStack((IItemProvider)Items.field_221796_dh)).addDrop(new ItemStack((IItemProvider)Items.field_221796_dh), 0, 4);
        this.getEntryByName("wheat").addSeeds(new ItemStack((IItemProvider)Items.field_151014_N)).addDrop(new ItemStack((IItemProvider)Items.field_151015_O), 0, 4);
        this.getEntryByName("wither_rose").addSeeds(new ItemStack((IItemProvider)Items.field_221690_bg)).addDrop(new ItemStack((IItemProvider)Items.field_221690_bg), 0, 1);
        this.getEntryByName("plantium").addSeeds(new ItemStack((IItemProvider)ModItems.PLANTIUM_NUGGET));
        this.getEntryByName("beast");
        this.getEntryByName("blaze");
        this.getEntryByName("chicken");
        this.getEntryByName("coal");
        this.getEntryByName("cow");
        this.getEntryByName("creeper");
        this.getEntryByName("dancium");
        this.getEntryByName("diamond");
        this.getEntryByName("dirt");
        this.getEntryByName("drowned");
        this.getEntryByName("emerald");
        this.getEntryByName("enderdragon");
        this.getEntryByName("enderman");
        this.getEntryByName("endstone");
        this.getEntryByName("fish");
        this.getEntryByName("ghast");
        this.getEntryByName("glowstone");
        this.getEntryByName("gold");
        this.getEntryByName("guardian");
        this.getEntryByName("husk");
        this.getEntryByName("illager");
        this.getEntryByName("iron");
        this.getEntryByName("kanekium");
        this.getEntryByName("kinnoium");
        this.getEntryByName("lapis");
        this.getEntryByName("lava");
        this.getEntryByName("lenthurium");
        this.getEntryByName("magma_cube");
        this.getEntryByName("mooshroom");
        this.getEntryByName("mycelium");
        this.getEntryByName("netherrack");
        this.getEntryByName("panda");
        this.getEntryByName("parrot");
        this.getEntryByName("pig");
        this.getEntryByName("polarbear");
        this.getEntryByName("prismarin");
        this.getEntryByName("quartz");
        this.getEntryByName("redstone");
        this.getEntryByName("sand");
        this.getEntryByName("sheep");
        this.getEntryByName("shulker");
        this.getEntryByName("skeleton");
        this.getEntryByName("slime");
        this.getEntryByName("snow");
        this.getEntryByName("soulsand");
        this.getEntryByName("spider");
        this.getEntryByName("sponge");
        this.getEntryByName("squid");
        this.getEntryByName("stone");
        this.getEntryByName("stray");
        this.getEntryByName("turtle");
        this.getEntryByName("villager");
        this.getEntryByName("water");
        this.getEntryByName("witch");
        this.getEntryByName("wither_skeleton");
        this.getEntryByName("wither");
        this.getEntryByName("wood");
        this.getEntryByName("zombie_pigman");
        this.getEntryByName("zombie_villager");
        this.getEntryByName("zombie");
    }
}

