/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kaneka.planttech2.container.DNARemoverContainer;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;

public class DNARemoverTileEntity
extends EnergyInventoryTileEntity {
    private int ticksPassed = 0;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return DNARemoverTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return DNARemoverTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return DNARemoverTileEntity.this.ticksPassed;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    DNARemoverTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    DNARemoverTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    DNARemoverTileEntity.this.ticksPassed = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public DNARemoverTileEntity() {
        super(ModTileEntities.DNAREMOVER_TE, 1000, 6, 4);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() > this.energyPerTick()) {
            List<String> traitsList;
            ItemStack stack1 = this.itemhandler.getStackInSlot(0);
            ItemStack stack2 = this.itemhandler.getStackInSlot(1);
            if (!stack1.func_190926_b() && stack2.func_190926_b() && stack1.func_77973_b() == ModItems.DNA_CONTAINER && (traitsList = this.getAvailableTraits(stack1)).size() > 1) {
                if (this.ticksPassed < this.ticksPerItem()) {
                    ++this.ticksPassed;
                    this.energystorage.extractEnergy(this.energyPerTick(), false);
                } else {
                    Collections.shuffle(traitsList);
                    CompoundNBT nbt = stack1.func_77978_p().func_74737_b();
                    nbt.func_82580_o(traitsList.get(0));
                    ItemStack stack = new ItemStack((IItemProvider)ModItems.DNA_CONTAINER);
                    stack.func_77982_d(nbt);
                    this.itemhandler.setStackInSlot(1, stack);
                    stack1.func_190918_g(1);
                    this.energystorage.extractEnergy(this.energyPerTick(), false);
                    this.ticksPassed = 0;
                    this.addKnowledge();
                }
            }
        }
        this.doEnergyLoop();
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    private List<String> getAvailableTraits(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            for (String key : HashMapCropTraits.getTraitsKeyList()) {
                if (!nbt.func_74764_b(key)) continue;
                list.add(key);
            }
        }
        return list;
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(2, 2) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(2, 2) * 35;
    }

    @Override
    public String getNameString() {
        return "dnaremover";
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("tickspassed", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.ticksPassed = compound.func_74762_e("tickspassed");
        super.func_230337_a_(state, compound);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new DNARemoverContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 3;
    }

    @Override
    public int getEnergyOutSlot() {
        return 4;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 5;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }
}

