/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.container.IdentifierContainer;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.librarys.CropListEntry;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class IdentifierTileEntity
extends EnergyInventoryTileEntity {
    public int ticksPassed = 0;
    private RangedWrapper inputs;
    private RangedWrapper outputs;
    private LazyOptional<IItemHandler> inputs_provider;
    private LazyOptional<IItemHandler> outputs_provider;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return IdentifierTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return IdentifierTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return IdentifierTileEntity.this.ticksPassed;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    IdentifierTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    IdentifierTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    IdentifierTileEntity.this.ticksPassed = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public IdentifierTileEntity() {
        super(ModTileEntities.IDENTIFIER_TE, 10000, 22, 1);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 9);
        this.outputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 9, 18);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
        this.outputs_provider = LazyOptional.of(() -> this.outputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.outputs_provider.cast();
            }
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() > this.getEnergyPerTickPerItem()) {
            if (this.canIdentify()) {
                this.energystorage.extractEnergy(this.getEnergyPerTickPerItem(), false);
                ++this.ticksPassed;
                if (this.ticksPassed >= this.getTicksPerItem()) {
                    this.identifyItem();
                    this.ticksPassed = 0;
                }
            } else if (this.ticksPassed > 0) {
                this.ticksPassed = 0;
            }
        } else if (!this.canIdentify() && this.ticksPassed > 0) {
            this.ticksPassed = 0;
        }
        this.doEnergyLoop();
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    private boolean canIdentify() {
        if (!this.hasFreeOutputSlot()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            CropListEntry entry;
            CompoundNBT nbt;
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (stack.func_190926_b() || !((nbt = stack.func_77978_p()) != null ? nbt.func_74764_b("analysed") && !nbt.func_74767_n("analysed") : (entry = PlantTechMain.croplist.getBySeed(stack)) != null)) continue;
            return true;
        }
        return false;
    }

    public void identifyItem() {
        if (this.canIdentify()) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.itemhandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                CompoundNBT nbt = stack.func_77978_p();
                if (nbt != null) {
                    if (!nbt.func_74764_b("analysed") || nbt.func_74767_n("analysed")) continue;
                    nbt.func_74757_a("analysed", true);
                    stack.func_77982_d(nbt);
                    this.itemhandler.setStackInSlot(this.getFreeOutputSlot(), stack);
                    this.itemhandler.setStackInSlot(i, ItemStack.field_190927_a);
                    this.addKnowledge();
                    break;
                }
                CropListEntry entry = PlantTechMain.croplist.getBySeed(stack);
                if (entry == null) continue;
                HashMapCropTraits newtraits = new HashMapCropTraits();
                newtraits.setType(entry.getString());
                newtraits.setAnalysed(true);
                ItemStack result = entry.getMainSeed().func_77946_l();
                result.func_190920_e(stack.func_190916_E());
                newtraits.addToItemStack(stack);
                this.itemhandler.setStackInSlot(this.getFreeOutputSlot(), result);
                this.itemhandler.setStackInSlot(i, ItemStack.field_190927_a);
                this.addKnowledge();
            }
        }
    }

    public boolean hasFreeOutputSlot() {
        for (int i = 9; i < 18; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (!stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public int getFreeOutputSlot() {
        for (int i = 9; i < 18; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (!stack.func_190926_b()) continue;
            return i;
        }
        return 9;
    }

    public int getEnergyPerTickPerItem() {
        return 4 + this.getUpgradeTier(18, 2) * 4;
    }

    public int getTicksPerItem() {
        return 200 - this.getUpgradeTier(18, 2) * 35;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("cooktime", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.ticksPassed = compound.func_74762_e("cooktime");
        super.func_230337_a_(state, compound);
    }

    @Override
    public String getNameString() {
        return "identifier";
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new IdentifierContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 19;
    }

    @Override
    public int getEnergyOutSlot() {
        return 20;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 21;
    }

    @Override
    public int getKnowledgePerAction() {
        return 5;
    }
}

