/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.container.MachineBulbReprocessorContainer;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.items.MachineBulbItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryFluidTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.Tags;

public class MachineBulbReprocessorTileEntity
extends EnergyInventoryFluidTileEntity {
    private int ticksPassed = 0;
    private int selectedId = 0;
    private int actualTier = 0;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return MachineBulbReprocessorTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return MachineBulbReprocessorTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return MachineBulbReprocessorTileEntity.this.BIOMASS_CAP.getCurrentStorage();
                }
                case 3: {
                    return MachineBulbReprocessorTileEntity.this.BIOMASS_CAP.getMaxStorage();
                }
                case 4: {
                    return MachineBulbReprocessorTileEntity.this.ticksPassed;
                }
                case 5: {
                    return MachineBulbReprocessorTileEntity.this.selectedId;
                }
                case 6: {
                    return MachineBulbReprocessorTileEntity.this.actualTier;
                }
                case 7: {
                    return MachineBulbReprocessorTileEntity.this.field_174879_c.func_177958_n();
                }
                case 8: {
                    return MachineBulbReprocessorTileEntity.this.field_174879_c.func_177956_o();
                }
                case 9: {
                    return MachineBulbReprocessorTileEntity.this.field_174879_c.func_177952_p();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    MachineBulbReprocessorTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    MachineBulbReprocessorTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    MachineBulbReprocessorTileEntity.this.BIOMASS_CAP.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    MachineBulbReprocessorTileEntity.this.BIOMASS_CAP.setMaxStorage(value);
                    break;
                }
                case 4: {
                    MachineBulbReprocessorTileEntity.this.ticksPassed = value;
                    break;
                }
                case 5: {
                    MachineBulbReprocessorTileEntity.this.selectedId = value;
                    break;
                }
                case 6: {
                    MachineBulbReprocessorTileEntity.this.actualTier = value;
                    break;
                }
                case 7: {
                    BlockPos newPos = new BlockPos(value, MachineBulbReprocessorTileEntity.this.field_174879_c.func_177956_o(), MachineBulbReprocessorTileEntity.this.field_174879_c.func_177952_p());
                    MachineBulbReprocessorTileEntity.this.field_174879_c = newPos;
                    break;
                }
                case 8: {
                    BlockPos newPos2 = new BlockPos(MachineBulbReprocessorTileEntity.this.field_174879_c.func_177958_n(), value, MachineBulbReprocessorTileEntity.this.field_174879_c.func_177952_p());
                    MachineBulbReprocessorTileEntity.this.field_174879_c = newPos2;
                    break;
                }
                case 9: {
                    BlockPos newPos3 = new BlockPos(MachineBulbReprocessorTileEntity.this.field_174879_c.func_177958_n(), MachineBulbReprocessorTileEntity.this.field_174879_c.func_177956_o(), value);
                    MachineBulbReprocessorTileEntity.this.field_174879_c = newPos3;
                }
            }
        }

        public int func_221478_a() {
            return 10;
        }
    };

    public MachineBulbReprocessorTileEntity() {
        super(ModTileEntities.MACHINEBULBREPROCESSOR_TE, 5000, 8, 5000, 0);
    }

    @Override
    public void doUpdate() {
        if (this.selectedId > 0 && this.selectedId <= ModItems.MACHINEBULBS.size()) {
            MachineBulbItem bulb = ModItems.MACHINEBULBS.get(this.selectedId - 1);
            if (this.energystorage.getEnergyStored() >= this.energyPerItem() && bulb.getTier() <= this.actualTier && this.BIOMASS_CAP.getCurrentStorage() >= bulb.getNeededBiomass()) {
                ItemStack input = this.itemhandler.getStackInSlot(0);
                ItemStack output = this.itemhandler.getStackInSlot(1);
                if (!input.func_190926_b() && output.func_190926_b() && (Tags.Items.SEEDS.func_230235_a_((Object)input.func_77973_b()) || input.func_77973_b() instanceof CropSeedItem)) {
                    if (this.ticksPassed < this.ticksPerItem()) {
                        ++this.ticksPassed;
                    } else {
                        this.energystorage.extractEnergy(this.energyPerItem());
                        this.BIOMASS_CAP.extractBiomass(bulb.getNeededBiomass());
                        input.func_190918_g(1);
                        this.ticksPassed = 0;
                        this.itemhandler.setStackInSlot(1, new ItemStack((IItemProvider)bulb));
                        this.addKnowledge();
                    }
                }
            }
        }
        this.checkTier();
        this.doEnergyLoop();
        this.doFluidLoop();
    }

    private void checkTier() {
        Item item;
        ItemStack stack = this.itemhandler.getStackInSlot(this.getKnowledgeChipSlot());
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) != null && item instanceof KnowledgeChip) {
            this.actualTier = ((KnowledgeChip)item).getTier();
            return;
        }
        this.actualTier = 0;
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    public int energyPerItem() {
        return 1000;
    }

    public int ticksPerItem() {
        return 300;
    }

    @Override
    public String getNameString() {
        return "machinebulbreprocessor";
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("tickspassed", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.ticksPassed = compound.func_74762_e("tickspassed");
        super.func_230337_a_(state, compound);
    }

    @Override
    protected int getFluidInSlot() {
        return 2;
    }

    @Override
    protected int getFluidOutSlot() {
        return 3;
    }

    @Override
    public int getEnergyInSlot() {
        return 4;
    }

    @Override
    public int getEnergyOutSlot() {
        return 5;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 6;
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new MachineBulbReprocessorContainer(id, inv, this);
    }

    public void setSelectedId(int buttonId) {
        this.selectedId = buttonId;
    }

    @Override
    public int getKnowledgePerAction() {
        return 10;
    }
}

